/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputnumber;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.extensions.component.inputnumber.InputNumber;
import org.primefaces.extensions.util.ExtWidgetBuilder;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;

public class InputNumberRenderer
extends InputRenderer {
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String submittedValueString = (String)submittedValue;
        if (ComponentUtils.isValueBlank((String)submittedValueString)) {
            return null;
        }
        Converter converter = ComponentUtils.getConverter((FacesContext)context, (UIComponent)component);
        if (converter != null) {
            return converter.getAsObject(context, component, submittedValueString);
        }
        return submittedValue;
    }

    public void decode(FacesContext context, UIComponent component) {
        InputNumber inputNumber = (InputNumber)component;
        if (inputNumber.isDisabled() || inputNumber.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputNumber);
        String inputId = inputNumber.getClientId(context) + "_hinput";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputNumber.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputNumber inputNumber = (InputNumber)component;
        this.encodeMarkup(context, inputNumber);
        this.encodeScript(context, inputNumber);
    }

    protected void encodeMarkup(FacesContext context, InputNumber inputNumber) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        String styleClass = inputNumber.getStyleClass();
        styleClass = styleClass == null ? "ui-inputNum ui-widget" : "ui-inputNum ui-widget " + styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputNumber.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputNumber.getStyle(), "style");
        }
        this.encodeOutput(context, inputNumber, clientId);
        this.encodeInput(context, inputNumber, clientId);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputNumber inputNumber, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_hinput";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (inputNumber.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)inputNumber.getOnchange(), null);
        }
        writer.endElement("input");
    }

    protected void encodeOutput(FacesContext context, InputNumber inputNumber, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String defaultClass = "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all pe-inputNumber";
        defaultClass = inputNumber.isValid() ? defaultClass : defaultClass + " ui-state-error";
        defaultClass = !inputNumber.isDisabled() ? defaultClass : defaultClass + " ui-state-disabled";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputNumber.getType(), null);
        this.renderPassThruAttributes(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_EVENTS);
        if (inputNumber.isReadonly()) {
            writer.writeAttribute("readonly", (Object)"readonly", "readonly");
        }
        if (inputNumber.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.writeAttribute("class", (Object)defaultClass, "");
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputNumber inputNumber) throws IOException {
        Object value = inputNumber.getValue();
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputNumber, (Object)value);
        if (valueToRender == null) {
            valueToRender = "";
        }
        ExtWidgetBuilder wb = ExtWidgetBuilder.get(context);
        wb.initWithDomReady(InputNumber.class.getSimpleName(), inputNumber.resolveWidgetVar(), inputNumber.getClientId());
        wb.attr("disabled", inputNumber.isDisabled()).attr("valueToRender", this.formatForPlugin(valueToRender, inputNumber, value));
        String metaOptions = this.getOptions(inputNumber);
        if (!metaOptions.isEmpty()) {
            wb.nativeAttr("pluginOptions", metaOptions);
        }
        wb.finish();
    }

    private String getOptions(InputNumber inputNumber) {
        String decimalSeparator = inputNumber.getDecimalSeparator();
        String thousandSeparator = inputNumber.getThousandSeparator();
        String symbol = inputNumber.getSymbol();
        String symbolPosition = inputNumber.getSymbolPosition();
        String minValue = inputNumber.getMinValue();
        String maxValue = inputNumber.getMaxValue();
        String roundMethod = inputNumber.getRoundMethod();
        String decimalPlaces = inputNumber.getDecimalPlaces();
        String emptyValue = inputNumber.getEmptyValue();
        String options = "";
        options = options + (decimalSeparator.isEmpty() ? "" : "aDec:\"" + this.escapeText(decimalSeparator) + "\",");
        options = options + (thousandSeparator.isEmpty() ? "aSep:''," : "aSep:\"" + this.escapeText(thousandSeparator) + "\",");
        options = options + (symbol.isEmpty() ? "" : "aSign:\"" + this.escapeText(symbol) + "\",");
        options = options + (symbolPosition.isEmpty() ? "" : "pSign:\"" + this.escapeText(symbolPosition) + "\",");
        options = options + (minValue.isEmpty() ? "" : "vMin:\"" + this.escapeText(minValue) + "\",");
        options = options + (maxValue.isEmpty() ? "" : "vMax:\"" + this.escapeText(maxValue) + "\",");
        options = options + (roundMethod.isEmpty() ? "" : "mRound:\"" + this.escapeText(roundMethod) + "\",");
        options = options + (decimalPlaces.isEmpty() ? "" : "mDec:\"" + this.escapeText(decimalPlaces) + "\",");
        if ((options = options + "wEmpty:\"" + this.escapeText(emptyValue) + "\",").isEmpty()) {
            return "";
        }
        int lastInd = options.length() - 1;
        if (options.charAt(lastInd) == ',') {
            options = options.substring(0, lastInd);
        }
        return "{" + options + "}";
    }

    private String formatForPlugin(String valueToRender, InputNumber inputNumber, Object value) {
        if (valueToRender == null || valueToRender.isEmpty()) {
            return "";
        }
        try {
            Number objectToRender = value instanceof BigDecimal ? new BigDecimal(valueToRender) : new Double(valueToRender);
            DecimalFormat formatter = new DecimalFormat("#0.0#");
            ((NumberFormat)formatter).setRoundingMode(RoundingMode.FLOOR);
            ((NumberFormat)formatter).setMinimumFractionDigits(15);
            ((NumberFormat)formatter).setMaximumFractionDigits(15);
            ((NumberFormat)formatter).setMaximumIntegerDigits(20);
            String f = formatter.format(objectToRender);
            f = f.replace(',', '.');
            return f;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a double value;", e);
        }
    }
}

