/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport;

import java.io.IOException;
import org.simpleframework.transport.Packet;
import org.simpleframework.transport.PacketController;
import org.simpleframework.transport.PacketFlusher;
import org.simpleframework.transport.PacketWriter;
import org.simpleframework.transport.Socket;
import org.simpleframework.transport.SocketFlusher;
import org.simpleframework.transport.SocketWriter;
import org.simpleframework.transport.reactor.Reactor;

class SocketController
implements PacketController {
    private final PacketFlusher flusher;
    private final PacketWriter writer;

    public SocketController(Socket socket, Reactor reactor, int threshold) throws IOException {
        this.writer = new SocketWriter(socket, threshold);
        this.flusher = new SocketFlusher(socket, reactor, this.writer);
    }

    public void write(Packet packet) throws IOException {
        boolean done = this.writer.write(packet);
        if (!done) {
            this.flusher.flush();
        }
    }

    public void flush() throws IOException {
        boolean done = this.writer.flush();
        if (!done) {
            this.flusher.flush();
        }
    }

    public void close() throws IOException {
        this.flusher.close();
        this.writer.close();
    }
}

