/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Category;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.enumeration.NetworkState;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Network
extends Resource {
    public static final String VLAN_ATTRIBUTE_NAME = "occi.network.vlan";
    public static final String LABEL_ATTRIBUTE_NAME = "occi.network.label";
    public static final String STATE_ATTRIBUTE_NAME = "occi.network.state";
    public static final URI SCHEME_DEFAULT = Category.SCHEME_INFRASTRUCTURE_DEFAULT;
    public static final String TERM_DEFAULT = "network";
    public static final String KIND_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "network";

    public Network(String id, Kind kind, String title, Model model, String summary) throws InvalidAttributeValueException {
        super(id, kind, title, model, summary);
    }

    public Network(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getVlan() {
        return this.getValue(VLAN_ATTRIBUTE_NAME);
    }

    public void setVlan(int vlan) throws InvalidAttributeValueException {
        this.addAttribute(VLAN_ATTRIBUTE_NAME, String.valueOf(vlan));
    }

    public void setVlan(String vlan) throws InvalidAttributeValueException {
        this.addAttribute(VLAN_ATTRIBUTE_NAME, vlan);
    }

    public String getLabel() {
        return this.getValue(LABEL_ATTRIBUTE_NAME);
    }

    public void setLabel(String label) throws InvalidAttributeValueException {
        this.addAttribute(LABEL_ATTRIBUTE_NAME, label);
    }

    public String getState() {
        return this.getValue(STATE_ATTRIBUTE_NAME);
    }

    public void setState(NetworkState state) throws InvalidAttributeValueException {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.addAttribute(STATE_ATTRIBUTE_NAME, state.toString());
    }

    public void setState(String stateName) throws InvalidAttributeValueException {
        this.addAttribute(STATE_ATTRIBUTE_NAME, stateName);
    }

    @Override
    public String getDefaultKindIdentifier() {
        return KIND_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.addAll(Resource.getDefaultAttributes());
        list.add(new Attribute(VLAN_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(LABEL_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(STATE_ATTRIBUTE_NAME, true, true));
        return list;
    }

    public static Kind getDefaultKind() {
        Kind kind = new Kind(SCHEME_DEFAULT, TERM_DEFAULT, "Network Resource", URI.create("/network/"), Network.getDefaultAttributes());
        return kind;
    }
}

