/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.collection;

import cz.cesnet.cloud.occi.type.Identifiable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SetCover<E extends Identifiable> {
    private final Set<E> set = new HashSet();

    public boolean contains(E element) {
        return this.set.contains(element);
    }

    public boolean contains(String elementIdentifier) {
        for (Identifiable element : this.set) {
            if (!element.getIdentifier().equals(elementIdentifier)) continue;
            return true;
        }
        return false;
    }

    public boolean add(E element) {
        if (element == null) {
            throw new NullPointerException("Cannot add null element.");
        }
        return this.set.add(element);
    }

    public boolean addAll(Collection<E> elements) {
        if (elements.contains(null)) {
            throw new NullPointerException("Cannot add null element.");
        }
        return this.set.addAll(elements);
    }

    public E get(String elementIdentifier) {
        if (!this.contains(elementIdentifier)) {
            return null;
        }
        return this.find(elementIdentifier);
    }

    public boolean remove(E element) {
        if (element == null) {
            throw new NullPointerException("Cannot remove null element.");
        }
        return this.set.remove(element);
    }

    private E find(String elementIdentifier) {
        for (Identifiable element : this.set) {
            if (!element.getIdentifier().equals(elementIdentifier)) continue;
            return (E)element;
        }
        return null;
    }

    public void clear() {
        this.set.clear();
    }

    public Set<E> getSet() {
        return this.getSet(false);
    }

    public Set<E> getSet(boolean modifiable) {
        if (modifiable) {
            return this.set;
        }
        return Collections.unmodifiableSet(this.set);
    }

    public int size() {
        return this.set.size();
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.set);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetCover other = (SetCover)obj;
        return Objects.equals(this.set, other.set);
    }

    public String toString() {
        return "SetCover{" + this.set + '}';
    }
}

