/*
 * Decompiled with CFR 0.152.
 */
package cz.cesnet.cloud.occi.infrastructure;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.core.Attribute;
import cz.cesnet.cloud.occi.core.Kind;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import cz.cesnet.cloud.occi.infrastructure.Network;
import cz.cesnet.cloud.occi.infrastructure.enumeration.Allocation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class IPNetwork
extends Network {
    public static final String ADDRESS_ATTRIBUTE_NAME = "occi.network.address";
    public static final String GATEWAY_ATTRIBUTE_NAME = "occi.network.gateway";
    public static final String ALLOCATION_ATTRIBUTE_NAME = "occi.network.allocation";
    public static final URI SCHEME_DEFAULT = URI.create("http://schemas.ogf.org/occi/infrastructure/network#");
    public static final String TERM_DEFAULT = "ipnetwork";
    public static final String MIXIN_IDENTIFIER_DEFAULT = SCHEME_DEFAULT + "ipnetwork";

    public IPNetwork(String id, Kind kind, String title, Model model, String summary) throws InvalidAttributeValueException {
        super(id, kind, title, model, summary);
    }

    public IPNetwork(String id, Kind kind) throws InvalidAttributeValueException {
        super(id, kind);
    }

    public String getAddress() {
        return this.getValue(ADDRESS_ATTRIBUTE_NAME);
    }

    public void setAddress(String address) throws InvalidAttributeValueException {
        this.addAttribute(ADDRESS_ATTRIBUTE_NAME, address);
    }

    public String getGateway() {
        return this.getValue(GATEWAY_ATTRIBUTE_NAME);
    }

    public void setGateway(String gateway) throws InvalidAttributeValueException {
        this.addAttribute(GATEWAY_ATTRIBUTE_NAME, gateway);
    }

    public String getAllocation() {
        return this.getValue(ALLOCATION_ATTRIBUTE_NAME);
    }

    public void setAllocation(Allocation allocation) throws InvalidAttributeValueException {
        if (allocation == null) {
            throw new NullPointerException("allocation cannot be null");
        }
        this.addAttribute(ALLOCATION_ATTRIBUTE_NAME, allocation.toString());
    }

    public void setAllocation(String allocationName) throws InvalidAttributeValueException {
        this.addAttribute(ALLOCATION_ATTRIBUTE_NAME, allocationName);
    }

    @Override
    public String getDefaultKindIdentifier() {
        return MIXIN_IDENTIFIER_DEFAULT;
    }

    public static List<Attribute> getDefaultAttributes() {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        list.add(new Attribute(ADDRESS_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(GATEWAY_ATTRIBUTE_NAME, false, false));
        list.add(new Attribute(ALLOCATION_ATTRIBUTE_NAME, false, false));
        return list;
    }

    public static Mixin getDefaultMixin() {
        Mixin mixin = new Mixin(SCHEME_DEFAULT, TERM_DEFAULT, "IP Network Mixin", URI.create("/mixins/ipnetwork/"), IPNetwork.getDefaultAttributes());
        return mixin;
    }
}

