package csbase.client.applications.algorithmsmanager.dialogs;

import javax.swing.JPanel;

import csbase.client.applications.algorithmsmanager.actions.CategoryCreateAction;
import csbase.client.applications.algorithmsmanager.actions.CommonEditAction;
import csbase.logic.algorithms.Category;

/**
 * Essa classe representa um painel para criao de uma nova categoria.
 * 
 * A criao  enviada para o servidor.
 * 
 */
public class CategoryCreateDataPanel extends CommonEditTabbedPanel {
  /** Painel com as informaes bsicas para criao da categoria */
  private CategoryCreateInfoPanel infoPanel;

  /**
   * Constri o painel para criao de uma categoria
   * 
   * @param action ao que criou esse painel
   */
  public CategoryCreateDataPanel(CommonEditAction action) {
    super(action);
  }

  /**
   * Obtm a ao de criar categoria que criou esse painel.
   * 
   * @return a ao de criar algoritmo
   */
  private CategoryCreateAction getCreateAction() {
    return (CategoryCreateAction) getAction();
  }

  /**
   * Cancela a criao da categoria.
   */
  protected void cancel() {
    getCreateAction().cancelCreation();
  }

  /**
   * Cria a categoria efetivamente no servidor.
   * 
   * @param categoryName nome da categoria
   * 
   * @return o algoritmo criado, ou null, caso tenha ocorrido algum erro
   */
  public Category createCategory(String categoryName) {
    return getCreateAction().createCategory(categoryName);
  }

  @Override
  public void initializeData() {
    infoPanel.initializeData();
  }

  @Override
  public boolean confirmDataChanged() {
    if (infoPanel.wasModified()) {
      // Confirma o cancelamento das abas alteradas
      return confirmCancelling();
    }
    return true;
  }

  @Override
  protected void buildAdditionalInfoPanel() {
  }

  @Override
  protected JPanel buildBasicInfoPanel() {
    infoPanel = new CategoryCreateInfoPanel(this);
    return infoPanel;
  }

  /**
   * Obtm o painel de seleo de categorias.
   * 
   * @return o painel de seleo de categorias
   */
  public CategorySelectionPanel getSelectionPanel() {
    return (CategorySelectionPanel) getCreateAction().getSelectionPanel();
  }

  /**
   * Obtm o nome da categoria pai.
   * 
   * @return retorna o nome da categoria pai, ou null, caso as novas categorias
   *         devam ser criadas na raiz (primeiro nvel)
   */
  public String getParentCategoryName() {
    return getCreateAction().getParentCategoryName();
  }

  /**
   * Obtm a categoria pai onde vai ser criada a nova categoria.
   * 
   * @return a categoria pai da nova categoria
   */
  public Category getParentCategory() {
    return getCreateAction().getParentCategory();
  }
}
