package csbase.client.applications.fileexchanger.actions;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.actions.core.FileExchangerAction;

/**
 * Ao para alternar visibilidade do painel de detalhes...
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ToggleDetailVisibilityAction extends FileExchangerAction {

  /**
   * Construtor
   * 
   * @param fileExchanger aplicao
   */
  public ToggleDetailVisibilityAction(FileExchanger fileExchanger) {
    super(fileExchanger);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() {
    final FileExchanger fileExchanger = getApplication();
    final boolean isVisible = fileExchanger.isDetailVisible();
    fileExchanger.setDetailVisible(!isVisible);
  }
}
