package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.ParametersTransferable;
import csbase.client.applications.flowapplication.messages.CopyMessage;

/**
 * Ao de menu popup que copia os valores dos parmetros de um n de fluxo de
 * algoritmos.
 * 
 * @author lmoreira
 */
public final class CopyParameterValuesAction extends GraphElementAction {
  /**
   * Cria a ao.
   * 
   * @param node O n (No aceita {@code null}).
   */
  public CopyParameterValuesAction(final GraphNode node) {
    super(node, CopyParameterValuesAction.class.getName() + ".name",
      ApplicationImages.ICON_COPY_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    final GraphNode node = (GraphNode) getElement();

    new CopyMessage(new ParametersTransferable(node)).sendVS(node);
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddNodePopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphNode graphNode,
        final Point2D point) {
        return new CopyParameterValuesAction(graphNode);
      }

    };
  }
}
