/*
 * $Id$
 */

package csbase.client.applications.projectsmanager.actions;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.proxy.LocateMissingAllocatedProjectsTask;
import csbase.client.desktop.DesktopFrame;
import csbase.logic.CommonClientProject;

/**
 * Ao que abre o dilogo para criao de projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class OpenProjectCreationDialogAction extends ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public OpenProjectCreationDialogAction(ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() throws Exception {
    ProjectsManager projectsManager = getProjectsManager();
    ApplicationFrame appFrame = projectsManager.getApplicationFrame();
    DesktopFrame desktopFrame = DesktopFrame.getInstance();
    CommonClientProject ccp = desktopFrame.openProjectCreationDialog(appFrame);
    if (ccp == null) {
      if (ProjectsManager.isCurrentUserAdmin()) {
        LocateMissingAllocatedProjectsTask lmapt =
          new LocateMissingAllocatedProjectsTask(projectsManager);

        String title = getString("OpenProjectCreationDialogAction.title");
        String msg = getString("OpenProjectCreationDialogAction.message");
        lmapt.execute(projectsManager.getApplicationFrame(), title, msg);

        if (lmapt.wasCancelled()) {
          String err =
            getString("OpenProjectCreationDialogAction.cancelled.message");
          lmapt.showError(err);
          return;
        }

        if (lmapt.getStatus() != true) {
          Exception exception = lmapt.getError();
          throw exception;
        }

        boolean result = lmapt.getResult();
        if (!result) {
          lmapt
            .showError(getString("OpenProjectCreationDialogAction.project.creation.error.message"));
        }
      }
    }
    projectsManager.refreshProjectsTable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_ADD_16;
  }

}
