package csbase.client.applications.serverdiagnostic;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationTask;
import csbase.logic.diagnosticservice.ServerDiagnosticInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * Tarefa responsvel por obter no servidor os dados apresentados na aplicao
 * de diagnstico.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ServerDiagnosticUpdateTask extends
  ApplicationTask<ServerDiagnosticInfo> {

  /**
   * Construtor
   * 
   * @param app referncia para a aplicao
   */
  public ServerDiagnosticUpdateTask(Application app) {
    super(app);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    ServerDiagnosticInfo info =
      ClientRemoteLocator.diagnosticService.getServerDiagnosticInfo();
    setResult(info);
  }
}
