package csbase.client.applications.sgamonitor.columns;

import javax.swing.table.TableCellRenderer;

import csbase.client.applications.sgamonitor.columns.util.JobProcessorPair;
import csbase.client.applications.sgamonitor.columns.util.NodeJobProcessorRenderer;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;

/**
 * Coluna que exibe o nmero de jobs (em execuo) e o nmero de processadores
 * de um n de cluster.
 * 
 * @author Tecgraf
 */
public class NodeJobProcessorColumn extends AbstractConfigurableColumn<SGAInfo> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   * @param visible - visibilidade da coluna.
   * @param stringProvider - utilizado para obter o nome da coluna
   *        internacionalizada.
   * @param align - alinhamento da coluna.
   */

  public NodeJobProcessorColumn(String id, Boolean visible,
    IStringProvider stringProvider, Integer align) {
    super(id, visible, stringProvider, align);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return JobProcessorPair.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getString(getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(SGAInfo obj) {
    return new JobProcessorPair(obj.getNumberOfJobs(), obj.getNumProcessors());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new NodeJobProcessorRenderer();
  }

}
