package csbase.client.csdk;

import java.util.Map;

import csbase.client.applicationmanager.ApplicationException;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.core.ICSDKEnvironment;

/**
 * Definio de uma fbrica de contextos do CSDK.
 * 
 * @param <T> a interface que representa os contextos CSDK.
 */
public interface IContextFactory<T> {

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao especificada atravs do ambiente CSDK
   * {@link ICSDKEnvironment#getContext(Class)}, indexados pelas interfaces CSDK
   * que eles implementam.
   * 
   * @param appInstanceId identificador da instncia da aplicao.
   * @param mainClass classe principal da aplicao.
   * @param registry o registro da aplicao.
   * @return o mapa de contextos.
   * 
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public Map<Class<? extends T>, T> createCSDKContexts(String appInstanceId,
    Class<? extends IApplication> mainClass, ApplicationRegistry registry)
    throws ApplicationException;
}
