/*
 * StarUsagePanel.java
 * 
 * @version $Revision: 150777 $
 */
package csbase.client.facilities.monitoring;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import tecgraf.javautils.core.lng.LNG;

/**
 * A classe <code>StarUsagePanel</code> modela o painel de monitorao que exibe
 * uma estrela (radar).
 * 
 * @author Andr Luiz Clinio
 */
public abstract class StarUsagePanel extends DynamicMonitorPanel {
  /** Painel que contm o grfico de estrela */
  private StarCanvas canvasPanel = null;

  /**
   * Repassa ao canvas a referncia para o gerenciador de informaes.
   * 
   * @param infoHandler referncia para o gerenciador das informaes
   *        visualizadas
   */
  public void setCanvasInfoHandler(DynamicInfoHandler infoHandler) {
    canvasPanel.setInfoHandler(infoHandler);
  }

  /**
   * Constri o painel que contm o canvas.
   * 
   * @return .
   */
  private StarCanvas createCanvasPanel() {
    canvasPanel = new StarCanvas();
    canvasPanel.setBorder(BorderFactory.createCompoundBorder(
      BorderFactory.createLoweredBevelBorder(),
      BorderFactory.createEmptyBorder(10, 10, 10, 10)));
    return canvasPanel;
  }

  /**
   * Constri o painel que contm os toggles de opes.
   * 
   * @return .
   */
  private JPanel createTogglePanel() {
    JPanel togPanel = new JPanel();
    togPanel.setLayout(new GridLayout(3, 2));
    final JCheckBox nameToggle = new JCheckBox(getNameToggleLabel(), false);
    nameToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setNameState(nameToggle.isSelected());
      }
    });

    final JCheckBox regionsToggle =
      new JCheckBox(LNG.get("MON_STAR_REGIONS_TOGGLE"), true);
    regionsToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setRegionsState(regionsToggle.isSelected());
      }
    });

    final JCheckBox radiusToggle =
      new JCheckBox(LNG.get("MON_STAR_RADIUS_TOGGLE"), false);
    radiusToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setRadiusState(radiusToggle.isSelected());
      }
    });

    final JCheckBox percToggle = new JCheckBox(getPercToggleLabel(), false);
    percToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setPercState(percToggle.isSelected());
      }
    });

    final JCheckBox refToggle =
      new JCheckBox(LNG.get("MON_STAR_REF_TOGGLE"), false);
    refToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setRefState(refToggle.isSelected());
      }
    });

    final JCheckBox scaleToggle =
      new JCheckBox(LNG.get("MON_STAR_SCALE_TOGGLE"), true);
    scaleToggle.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ae) {
        canvasPanel.setScaleState(scaleToggle.isSelected());
      }
    });
    togPanel.add(nameToggle);
    togPanel.add(percToggle);
    togPanel.add(radiusToggle);
    togPanel.add(regionsToggle);
    togPanel.add(refToggle);
    togPanel.add(scaleToggle);
    return togPanel;
  }

  /**
   * Constri o painel que contm slider de zoom.
   * 
   * @return .
   */
  public JSlider createSliderPanel() {
    final JSlider factorSlider = new JSlider(JSlider.VERTICAL, 1, 10, 1);
    factorSlider.setMajorTickSpacing(1);
    factorSlider.setMinorTickSpacing(1);
    factorSlider.setPaintTicks(true);
    factorSlider.setPaintLabels(true);
    factorSlider.addChangeListener(new ChangeListener() {
      @Override
      public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider) e.getSource();
        canvasPanel.setFactor(source.getValue());
      }
    });
    factorSlider.setBorder(BorderFactory.createCompoundBorder(
      BorderFactory.createEmptyBorder(10, 10, 10, 10),
      BorderFactory.createTitledBorder(LNG.get("MON_STAR_ZOOM"))));
    return factorSlider;
  }

  /**
   * Obtm a legenda do toggle para nomes.
   * 
   * @return .
   */
  public abstract String getNameToggleLabel();

  /**
   * Obtm a legenda do toggle para ocupao/percentual.
   * 
   * @return .
   */
  public abstract String getPercToggleLabel();

  /**
   * Retorna o ttulo do painel.
   * 
   * @return ttulo do painel
   */
  @Override
  public abstract String getTitle();

  /**
   * Atualiza as informaes dinmicas exibidas.
   * 
   * @param dynamicData informaes do servidor
   */
  public abstract void updateDynamicInfo(Object[] dynamicData);

  /**
   * Constri o painel de monitorao tipo radar.
   */
  public StarUsagePanel() {
    super();
    setLayout(new BorderLayout());
    add(createCanvasPanel(), BorderLayout.CENTER);
    add(createTogglePanel(), BorderLayout.SOUTH);
    add(createSliderPanel(), BorderLayout.WEST);
  }
}
