/*
 * $Id: TextViewer.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.facilities.textviewer;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;

/**
 * A classe <code>TextViewer</code> implementa um visualizador de texto (ascii).
 * As informaes exibidas no podem ser editadas.
 */
public class TextViewer {
  /**
   * Texto exibido na janela.
   */
  private String text;

  /**
   * Ttulo da janela.
   */
  private String title;

  /**
   * Dilogo principal do visualizador.
   */
  final private DesktopComponentFrame mainFrame;

  /**
   * Exibe a janela.
   */
  final public void showDialog() {
    final DesktopFrame desktop = DesktopFrame.getInstance();
    final DesktopComponentFrame desktopFrame = desktop.getDesktopFrame();
    mainFrame.center(desktopFrame);
    mainFrame.setVisible(true);
  }

  /**
   * Cria a janela de visualizao de texto.
   * 
   * @return referncia para a janela criada
   */
  private DesktopComponentFrame createMainFrame() {
    final DesktopComponentFrame frm = new DesktopComponentFrame("");
    frm.addWindowListener(new WindowAdapter() {
      @Override
      public void windowClosing(WindowEvent we) {
        frm.close();
      }
    });

    Container cp = frm.getContentPane();
    cp.add(createViewer(), BorderLayout.CENTER);
    cp.add(createButtonsPanel(), BorderLayout.SOUTH);

    frm.setTitle(title);
    frm.setSize(600, 400);
    return frm;
  }

  /**
   * Cria o painel do visualizador.
   * 
   * @return painel principal.
   */
  private JComponent createViewer() {
    final JEditorPane textPane = new JEditorPane();
    textPane.setFont(new Font(Font.MONOSPACED, Font.PLAIN, 12));
    textPane.setEditable(false);
    textPane.setText(text);
    final JScrollPane textScrolledPane = new JScrollPane(textPane);
    textScrolledPane
      .setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
    return textScrolledPane;
  }

  /**
   * Cria o painel de botes.
   * 
   * @return painel de botes
   */
  private JPanel createButtonsPanel() {
    JPanel bp = new JPanel(new FlowLayout());

    // Boto de fechamento da janela
    JButton exitButton = new JButton(LNG.get("textviewer.button.exit"));
    exitButton.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent ev) {
        mainFrame.close();
      }
    });
    bp.add(exitButton);
    return bp;
  }

  /**
   * Constri e exibe o visualizador de texto.
   * 
   * @param text O texto a ser exibido.
   */
  public TextViewer(String text) {
    this(text, LNG.get("textviewer.title"));
  }

  /**
   * Constri e exibe o visualizador de texto, especificando o ttulo da janela.
   * 
   * @param text O texto a ser exibido.
   * @param title O ttulo da janela.
   */
  public TextViewer(String text, String title) {
    this.text = text;
    this.title = title;
    this.mainFrame = createMainFrame();
  }
}
