/*
 * ClientException.java
 * $Author: cassino $
 * $Revision: 33587 $  - $Date: 2004-04-15 11:21:24 -0300 (Thu, 15 Apr 2004) $
 */
package csbase.client.kernel;

/**
 * A classe <code>ClientException</code> representa uma exceo do cliente
 */
public class ClientException extends Exception {
  /**
   * Constri uma exceo vazia
   */
  public ClientException() {
    super("Exceo vazia - ClientException");
  }

  /**
   * Constri uma exceo contendo sua descrio.
   *
   * @param message a descrio do erro
   */
  public ClientException(String message) {
    super(message);
  }

  /**
   * Constri uma exceo contendo a causa/exceo original
   *
   * @param exception a exceo original
   */
  public ClientException(Throwable exception) {
    super(exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original
   *
   * @param message a descrio do erro
   * @param exception a exceo original
   */
  public ClientException(String message, Throwable exception) {
    super(message, exception);
  }
}
