package csbase.client.project;

import javax.swing.tree.TreePath;

import csbase.util.collections.NoDuplicatesCollection;

/**
 * Os mtodos addSelectionPath(s), setSelectionPath(s) e
 * removeSelectionPath(s) tem comportamentos diferentes, de acordo com o modo
 * de seleo escolhido. A classe ProjectTreeSelectionModel delega a execuo
 * desse mtodos para o SelectionModeState correspondente ao seu modo de
 * seleo.
 * 
 * @author Rodrigo Carneiro Henrique (rodrigoh)
 * @version $Revision: 105206 $
 */
interface SelectionModeStateInterface {
  /**
   * Adiciona os elementos recebidos  lista de paths selecionados.
   * 
   * @param treePathCollection Uma coleo com elementos do tipo
   *        {@link TreePath} que sero adicionados  seleo.
   */
  void addSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection);

  /**
   * Atualiza a lista de paths selecionados para conter apenas os elementos
   * recebidos.
   * 
   * @param treePathCollection Uma coleo com elementos do tipo
   *        {@link TreePath} que comporo  seleo.
   */
  void setSelectionPaths(NoDuplicatesCollection<TreePath> treePathCollection);

  /**
   * Remove os elementos recebidos da lista de paths selecionados.
   * 
   * @param treePathCollection Uma coleo com elementos do tipo
   *        {@link TreePath} que sero removidos da seleo.
   */
  void removeSelectionPaths(
    NoDuplicatesCollection<TreePath> treePathCollection);
}