/*
 * Detalhes da ltima alterao:
 * 
 * $Author: oikawa $ $Date$ $Revision: 150777 $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.dialogs.UpdateFileDialog;
import csbase.logic.ClientProjectFile;

/**
 * Representa a ao que executa o dilogo de atualizao de um arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class CommonFileUpdateAction extends CommonProjectAction {
  /**
   * Prefixo das chaves de traduo.
   */
  private static final String LNG_PREFIX = "CommonFileUpdateAction.";

  /**
   * Cria a ao de execuo do dilogo de atualizao de um arquivo.
   * 
   * @param container O container onde a ao foi executada.
   */
  public CommonFileUpdateAction(ProjectFileContainer container) {
    super(container);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final DesktopFrame desktopFrame = DesktopFrame.getInstance();
    final DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
    final ClientProjectFile file = getSelectedFile();
    UpdateFileDialog dialog = new UpdateFileDialog(frame, file);
    dialog.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return LNG.get(LNG_PREFIX + "name");
  }
}
