/*
 * ProjectDeleteAction.java
 * 
 * $Id: ProjectDeleteAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.Window;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.CommonProjectDeleteDialog;
import csbase.client.project.ProjectTree;

/**
 * Ao que remove um projeto de um usurio.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectDeleteAction extends AbstractAction {

  /**
   * Dilogo pai.
   */
  final private Window ownerDialog;

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    CommonProjectDeleteDialog dialog =
      new CommonProjectDeleteDialog(ownerDialog);
    dialog.setVisible(true);
  }

  /**
   * Construtor.
   * 
   * @param treeView view da rvore.
   */
  public ProjectDeleteAction(ProjectTree treeView) {
    this.ownerDialog = treeView.getWindow();
    putValue(NAME, LNG.get("PRJ_REMOVAL"));
  }
}
