/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache.events;

import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.util.event.EventListener;
import csbase.logic.CommandInfo;

public abstract class AbstractCommandUpdatedEventListener
implements EventListener<CommandUpdatedEvent> {
    private final Object projectId;
    private final String commandId;

    public AbstractCommandUpdatedEventListener(Object projectId, String commandId) {
        this.projectId = projectId;
        this.commandId = commandId;
    }

    @Override
    public final void eventFired(CommandUpdatedEvent event) {
        if (CommandUpdatedEvent.Type.exception == event.getType()) {
            this.eventInterrupted(event.getException(), event.getExceptionDescription());
        } else if (this.commandId.equals(event.getCommand().getId())) {
            this.eventFired(event.getType(), event.getCommand());
        }
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public final String getCommandId() {
        return this.commandId;
    }

    protected abstract void eventFired(CommandUpdatedEvent.Type var1, CommandInfo var2);

    protected void eventInterrupted(Exception exception, String description) {
    }
}

