/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.DefaultIntegerTextFieldModel;
import csbase.client.algorithms.parameters.NumberTextField;
import csbase.client.algorithms.parameters.NumberTextFieldModel;
import csbase.exception.ParseException;

public class IntegerTextField
extends NumberTextField<Integer> {
    public IntegerTextField(Integer errorValue) {
        this(new DefaultIntegerTextFieldModel(errorValue));
    }

    public IntegerTextField(NumberTextFieldModel<Integer> model) {
        super(model);
    }

    @Override
    protected String format(Integer number) {
        return number.toString();
    }

    @Override
    protected Integer parse(String text) throws ParseException {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            throw new ParseException("O texto informado n\u00e3o representa um n\u00famero inteiro.\nTexto: ({0}).", new Object[]{text});
        }
    }
}

