/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.DataPropertiesListener;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmsAndCategoriesBindPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryTreeView;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;

public class CategoryBasicInfoPanel
extends CommonInfoEditPanel {
    private JTextField tf_categoryParentName;
    private JTextField tf_categoryName;
    private boolean isEditing;
    private AlgorithmsAndCategoriesBindPanel bindPanel;

    public CategoryBasicInfoPanel(CategoryEditDataPanel categoryPane) {
        super(categoryPane);
    }

    private JPanel getUpdatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel categoryNameLabel = new JLabel(this.getString("CategoryBasicInfoPanel.label.name"));
        JLabel parentCategoryNameLabel = new JLabel(this.getString("CategoryBasicInfoPanel.label.parent.name"));
        this.tf_categoryParentName = new JTextField();
        this.tf_categoryParentName.setEditable(false);
        this.tf_categoryName = new JTextField(20);
        this.tf_categoryName.setEditable(false);
        panel.add((Component)parentCategoryNameLabel, new GBC(0, 0).none().west().insets(5, 5, 5, 5));
        panel.add((Component)this.tf_categoryParentName, new GBC(1, 0).horizontal().west().insets(5, 5, 5, 5));
        panel.add((Component)categoryNameLabel, new GBC(0, 1).none().west().insets(5, 5, 5, 5));
        panel.add((Component)this.tf_categoryName, new GBC(1, 1).horizontal().west().insets(5, 5, 5, 5));
        panel.add((Component)this.getDataBindingPanel(), new GBC(0, 2).gridwidth(2).both().west().insets(5, 5, 5, 5));
        return panel;
    }

    protected String getFieldCategoryName() {
        return this.tf_categoryName.getText();
    }

    @Override
    public void initializeData() {
        if (this.getSelectedCategory() == null) {
            return;
        }
        if (!this.isEditing) {
            this.tf_categoryParentName.setText(this.getSelectedCategoryParentName());
            this.tf_categoryName.setText(this.getSelectedCategoryName());
            this.tf_categoryName.requestFocus();
            this.bindPanel.initializeData(this.getSelectedCategory(), this.getAvailableAlgorithms(), this.getCategoryAlgorithms());
            this.revalidate();
        }
        this.changeOperationsState(this.isEditing);
    }

    private SortedSet<DataInterface> getCategoryAlgorithms() {
        CategoryNodeInterface categoryData;
        SortedSet<DataInterface> selectedData = new TreeSet<DataInterface>();
        if (this.getSelectedCategory() != null && !(categoryData = this.getSelectedCategory()).isRootNode()) {
            Set algorithms = categoryData.getNode().getAlgorithms();
            selectedData = this.getAlgorithmDataInterfaceSet(algorithms);
        }
        return selectedData;
    }

    private SortedSet<DataInterface> getAlgorithmDataInterfaceSet(Set<AlgorithmInfo> algorithms) {
        TreeSet<DataInterface> algorithmsDataSet = new TreeSet<DataInterface>();
        for (AlgorithmInfo algoInfo : algorithms) {
            algorithmsDataSet.add(new AlgorithmData(algoInfo));
        }
        return algorithmsDataSet;
    }

    private SortedSet<DataInterface> getAvailableAlgorithms() {
        TreeSet<DataInterface> availableData = new TreeSet();
        availableData = this.getAllAgorithms();
        if (this.getSelectedCategory() == null) {
            return availableData;
        }
        CategoryNodeInterface categoryData = this.getSelectedCategory();
        if (!categoryData.isRootNode()) {
            Set dataChildren = categoryData.getNode().getAlgorithms();
            Iterator availableIterator = availableData.iterator();
            while (availableIterator.hasNext()) {
                DataInterface node = (DataInterface)availableIterator.next();
                if (!dataChildren.contains(node)) continue;
                availableIterator.remove();
            }
        }
        return availableData;
    }

    private SortedSet<DataInterface> getAllAgorithms() {
        SortedSet<AlgorithmInfo> allAgorithms = ((AlgorithmsManager)this.getApplication()).getAllAgorithms();
        return this.getAlgorithmDataInterfaceSet(allAgorithms);
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        this.saveInfo();
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        return this.getUpdatePanel();
    }

    @Override
    protected void cancel() {
        if (this.confirmCancelling()) {
            this.initializeData();
        }
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("CategoryBasicInfoPanel.msg.cancel.confirm"), new String[]{this.getString("CategoryBasicInfoPanel.msg.cancel.confirm.yes"), this.getString("CategoryBasicInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    private JPanel getDataBindingPanel() {
        if (this.bindPanel == null) {
            this.bindPanel = new AlgorithmsAndCategoriesBindPanel((AlgorithmsManager)this.getApplication(), this.getSelectedCategory(), this.getAvailableAlgorithms(), this.getCategoryAlgorithms(), AlgorithmsAndCategoriesBindPanel.ItemType.ALGORITHM_ITEM);
            this.bindPanel.addBindListener(new DataPropertiesListener(){

                @Override
                public void propertiesChanged(boolean wasModified) {
                    CategoryBasicInfoPanel.this.isEditing = wasModified;
                    CategoryBasicInfoPanel.this.changeOperationsState(wasModified);
                }
            });
        }
        return this.bindPanel;
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    private String getSelectedCategoryName() {
        if (this.getSelectedCategory() != null) {
            return this.getSelectedCategory().getName();
        }
        return null;
    }

    public String getSelectedCategoryParentName() {
        if (this.getSelectedCategory() != null) {
            Category parentCategory = null;
            parentCategory = this.getSelectedCategory().getNode().getParentCategory();
            if (parentCategory != null) {
                return parentCategory.getFullName();
            }
            return CategoryTreeView.ROOT_NAME;
        }
        return null;
    }

    protected boolean saveInfo() {
        this.bindPanel.bindData();
        return true;
    }

    private CategoryNodeInterface getSelectedCategory() {
        return this.getCategoryEditDataPanel().getSelectedCategory();
    }

    private CategoryEditDataPanel getCategoryEditDataPanel() {
        return (CategoryEditDataPanel)this.getEditPanel();
    }

    @Override
    public boolean wasModified() {
        return this.bindPanel.wasModified();
    }

    @Override
    protected String getTitle() {
        return ((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.tab.info.basic");
    }

    private class AlgorithmData
    implements DataInterface,
    Comparable<AlgorithmData> {
        private AlgorithmInfo algoInfo;

        AlgorithmData(AlgorithmInfo algoInfo) {
            this.algoInfo = algoInfo;
        }

        @Override
        public String getName() {
            return this.algoInfo.getName();
        }

        @Override
        public String getId() {
            return this.algoInfo.getId();
        }

        @Override
        public Icon getIcon() {
            return ApplicationImages.ICON_ALGORITHM_16;
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        @Override
        public int compareTo(AlgorithmData algoData) {
            return this.algoInfo.getId().compareToIgnoreCase(algoData.getId());
        }
    }
}

