/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.VersionNodeInterface;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeRootNode;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.GBC;

public class VersionTreeView {
    private AlgorithmVersionInfoPanel versionInfoPanel;
    private VersionTree versionTree;
    private JPanel versionTreePanel;
    private boolean infoAlreadyUpdated;
    private int currentVersionRow;
    public static String ROOT_NAME;

    public VersionTreeView(AlgorithmVersionInfoPanel versionInfoPanel, AlgorithmInfo algorithmInfo) {
        this.versionInfoPanel = versionInfoPanel;
        this.currentVersionRow = -1;
        ROOT_NAME = this.getApplication().getString("VersionTreeView.root.label.versions");
        this.getVersionTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object node = e.getPath().getLastPathComponent();
                TreeNode treeNode = (TreeNode)node;
                VersionTreeView.this.initVersionSelection(treeNode);
            }
        });
    }

    private Application getApplication() {
        return this.versionInfoPanel.getApplication();
    }

    private void initVersionSelection(TreeNode treeNode) {
        if (this.infoAlreadyUpdated) {
            this.versionInfoPanel.verifyAndChangeButtonsState();
        } else {
            if (this.changedSelectedVersion()) {
                if (!this.versionInfoPanel.confirmSelectionChanged()) {
                    this.setCurrentNode();
                    return;
                }
                this.currentVersionRow = this.getSelectedRow();
            }
            VersionTreeNode versionNode = this.getVersionNode(treeNode);
            this.versionInfoPanel.initVersionNodeEdition(versionNode);
        }
        this.versionInfoPanel.enableVersionEditPanel(treeNode instanceof VersionTreeNode);
    }

    public JPanel getVersionTreePanel() {
        if (this.versionTreePanel == null) {
            this.versionTreePanel = new JPanel(new GridBagLayout());
            this.versionTreePanel.add((Component)new JScrollPane(this.getVersionTree()), new GBC(0, 0).both().west().insets(0, 0, 0, 0));
        }
        return this.versionTreePanel;
    }

    public VersionNodeInterface getFirstSelectedNode() {
        VersionNodeInterface node = null;
        int selectedCount = this.versionTree.getSelectionCount();
        if (selectedCount == 1) {
            Object selectionPath = this.versionTree.getSelectionPath().getLastPathComponent();
            node = (VersionNodeInterface)selectionPath;
        }
        return node;
    }

    public int getSelectedRow() {
        int[] selectionRows = this.versionTree.getSelectionRows();
        if (selectionRows != null && selectionRows.length > 0) {
            return selectionRows[0];
        }
        return 0;
    }

    public List<VersionNodeInterface> getSelectedDataList() {
        ArrayList<VersionNodeInterface> selectedDataList = new ArrayList<VersionNodeInterface>();
        TreePath[] selectionPaths = this.versionTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath treePath : selectionPaths) {
                Object treeNode = treePath.getLastPathComponent();
                if (!(treeNode instanceof VersionNodeInterface)) continue;
                selectedDataList.add((VersionNodeInterface)treeNode);
            }
        }
        return selectedDataList;
    }

    public List<VersionNodeInterface> getFullPathSelectedNode() {
        ArrayList<VersionNodeInterface> fullPath = new ArrayList<VersionNodeInterface>();
        int selectedCount = this.versionTree.getSelectionCount();
        if (selectedCount == 1) {
            Object[] paths = this.versionTree.getSelectionPath().getPath();
            VersionTreeRootNode rootNode = (VersionTreeRootNode)paths[0];
            fullPath.add(rootNode);
            for (Object path : paths) {
                if (!(path instanceof VersionTreeNode)) continue;
                VersionTreeNode node = (VersionTreeNode)path;
                fullPath.add(node);
            }
        }
        return fullPath;
    }

    public VersionTreeRootNode getRootNode() {
        TreePath rootPath = this.versionTree.getPathForRow(0);
        Object treeNode = rootPath.getLastPathComponent();
        if (treeNode instanceof VersionTreeRootNode) {
            return (VersionTreeRootNode)treeNode;
        }
        return null;
    }

    protected VersionNodeInterface getNode(TreePath path) {
        Object lastPath;
        if (path != null && VersionNodeInterface.class.isAssignableFrom((lastPath = path.getLastPathComponent()).getClass())) {
            return (VersionNodeInterface)lastPath;
        }
        return null;
    }

    public boolean isRootNodeSelected() {
        return this.versionTree.isRowSelected(0);
    }

    public int getSelectionCount() {
        return this.versionTree.getSelectionCount();
    }

    public VersionTree getVersionTree() {
        if (this.versionTree == null) {
            AlgorithmListItem selectedAlgorithmItem = this.versionInfoPanel.getSelectedAlgorithmItem();
            AlgorithmInfo algoInfo = selectedAlgorithmItem == null ? null : selectedAlgorithmItem.getItem();
            this.versionTree = new VersionTree(this.getApplication().getApplicationFrame(), algoInfo);
        }
        return this.versionTree;
    }

    public void initializeVersionTree(AlgorithmInfo algoInfo) {
        this.getVersionTree().initializeTree(algoInfo);
        this.getVersionTreePanel().revalidate();
    }

    public VersionTreeNode getVersionNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        if (treeNode instanceof VersionTreeRootNode) {
            return null;
        }
        if (treeNode instanceof VersionTreeNode) {
            return (VersionTreeNode)treeNode;
        }
        TreeNode parent = treeNode.getParent();
        return this.getVersionNode(parent);
    }

    private boolean changedSelectedVersion() {
        return this.currentVersionRow != this.getSelectedRow();
    }

    private void selectRootNode() {
        this.versionTree.setSelectionRow(0);
    }

    private void selectNode(int nodeRow) {
        this.versionTree.selectNode(nodeRow);
    }

    private void selectCurrentNode() {
        if (this.currentVersionRow == -1) {
            this.selectRootNode();
        }
        this.selectNode(this.currentVersionRow);
    }

    public void setCurrentNode() {
        this.infoAlreadyUpdated = true;
        this.selectCurrentNode();
        this.infoAlreadyUpdated = false;
    }

    public void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
        this.infoAlreadyUpdated = true;
        this.versionTree.replaceAlgoNode(algoInfo);
        this.infoAlreadyUpdated = false;
        this.selectCurrentNode();
    }
}

