/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.zoom;

import csbase.client.applications.flowapplication.zoom.ZoomListener;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import javax.swing.AbstractSpinnerModel;

public final class ZoomSpinnerModel
extends AbstractSpinnerModel {
    private final ZoomModel zoomModel;

    public ZoomSpinnerModel(ZoomModel zoomModel) {
        this.zoomModel = zoomModel;
        this.zoomModel.addListener(new ZoomSpinnerModelListener());
    }

    @Override
    public Object getNextValue() {
        return ZoomSpinnerModel.toSpinnerValue(this.zoomModel.getNextUnitValue());
    }

    @Override
    public Object getPreviousValue() {
        return ZoomSpinnerModel.toSpinnerValue(this.zoomModel.getPreviousUnitValue());
    }

    @Override
    public Object getValue() {
        return ZoomSpinnerModel.toSpinnerValue(this.zoomModel.getValue());
    }

    @Override
    public void setValue(Object value) {
        this.zoomModel.setValue(ZoomSpinnerModel.fromSpinnerValue(value));
    }

    private static double fromSpinnerValue(Object zoomValue) {
        String stringValue = (String)zoomValue;
        return (double)Integer.parseInt(stringValue) / 100.0;
    }

    private static Object toSpinnerValue(double zoomValue) {
        int intValue = (int)Math.round(zoomValue * 100.0);
        return Integer.toString(intValue);
    }

    private class ZoomSpinnerModelListener
    implements ZoomListener {
        private ZoomSpinnerModelListener() {
        }

        @Override
        public void wasChanged(ZoomModel model) {
            ZoomSpinnerModel.this.fireStateChanged();
        }
    }
}

