/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsynchronization;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.projectsynchronization.ProjectSynchronizationRemoteTask;
import csbase.client.applications.projectsynchronization.ProjectSynchronizationWizardMonitor;
import csbase.client.applications.projectsynchronization.StepConclusion;
import csbase.client.applications.projectsynchronization.StepSelectionFilesA;
import csbase.client.applications.projectsynchronization.StepSelectionFilesB;
import csbase.client.applications.projectsynchronization.StepSelectionProjects;
import csbase.client.applications.projectsynchronization.StepSelectionServers;
import csbase.logic.ProjectSynchronizationData;
import csbase.logic.ProjectSynchronizationResult;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.Step;
import tecgraf.javautils.gui.wizard.StepGroup;
import tecgraf.javautils.gui.wizard.Wizard;
import tecgraf.javautils.gui.wizard.WizardException;
import tecgraf.javautils.gui.wizard.WizardListener;

public class ProjectSynchronization
extends Application
implements WizardListener {
    private Wizard wizard;
    private StepConclusion stepConclusion;
    private ProjectSynchronizationRemoteTask task;

    public ProjectSynchronization(String id) {
        super(id);
        this.buildFrame();
    }

    private void buildFrame() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        String remoteServer = this.getStringSpecificProperty("remoteServer");
        String remotePort = this.getStringSpecificProperty("remotePort");
        ArrayList<StepGroup> list = new ArrayList<StepGroup>();
        StepGroup sg = new StepGroup(this.getString("desc.step1"));
        sg.add((Step)new StepSelectionServers(this.getApplicationRegistry(), remoteServer, remotePort));
        list.add(sg);
        sg = new StepGroup(this.getString("desc.step2"));
        sg.add((Step)new StepSelectionProjects(this.getApplicationRegistry()));
        list.add(sg);
        sg = new StepGroup(this.getString("desc.step3"));
        sg.add((Step)new StepSelectionFilesA(this.getApplicationRegistry()));
        list.add(sg);
        sg = new StepGroup(this.getString("desc.step4"));
        sg.add((Step)new StepSelectionFilesB(this.getApplicationRegistry()));
        list.add(sg);
        sg = new StepGroup(this.getString("desc.step5"));
        this.stepConclusion = new StepConclusion(this.getApplicationRegistry());
        sg.add((Step)this.stepConclusion);
        list.add(sg);
        this.wizard = new Wizard(StepSelectionServers.class, list);
        this.wizard.addListener((WizardListener)this);
        ((JFrame)mainFrame).getContentPane().add((Component)this.wizard);
        mainFrame.setPreferredSize(new Dimension(900, 420));
        mainFrame.pack();
    }

    @Override
    public void killApplication() {
    }

    @Override
    public boolean userCanKillApplication() {
        return true;
    }

    public void wasCancelled(Step arg0) {
    }

    public void wasClosed(Step arg0) {
        this.finishApplication();
    }

    public void wasConfirmed(Step arg0, Object obj) {
        ProjectSynchronizationData data = (ProjectSynchronizationData)obj;
        JEditorPane textArea = this.stepConclusion.getContainerConclusion().getEConclusion();
        String text = this.stepConclusion.getContainerConclusion().getText();
        try {
            ProjectSynchronizationWizardMonitor monitor = new ProjectSynchronizationWizardMonitor(textArea, new StringBuffer(text), this);
            this.task = new ProjectSynchronizationRemoteTask(data, monitor);
            this.task.execute(this.getApplicationFrame(), this.getName(), this.getString("ProjectSynchronization.synchronizing"), 0, 0, false, true);
            if (monitor.isCancelled()) {
                this.showInformation(this.getString("ProjectSynchronization.canceled.msg"));
            } else {
                ProjectSynchronizationResult result = (ProjectSynchronizationResult)this.task.getResult();
                if (result.succeeded()) {
                    this.showInformation(this.getString("ProjectSynchronization.success.msg"));
                } else {
                    Throwable cause = result.getCause();
                    if (cause == null) {
                        this.showError(this.getString("ProjectSynchronization.failure.msg"));
                    } else {
                        this.showException(result.getMessage(), result.getCause());
                    }
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void wasGoneNext(Step arg0, History arg1) {
    }

    public void wasGonePrevious(Step arg0, History arg1) {
    }

    public void wasHappenedException(Step arg0, WizardException arg1) {
    }

    public ProjectSynchronizationRemoteTask getTask() {
        return this.task;
    }
}

