/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;

public abstract class DesktopAction<T extends DesktopFrame>
extends AbstractAction {
    private final T desktop;

    protected final T getDesktop() {
        return this.desktop;
    }

    protected final String getString(String key) {
        String className = this.getClass().getSimpleName();
        String formattedKey = String.format("%s.%s", className, key);
        if (LNG.hasKey((String)formattedKey)) {
            return LNG.get((String)formattedKey);
        }
        return "<<" + formattedKey + ">>";
    }

    protected final String getString(String key, Object ... args) {
        String className = this.getClass().getSimpleName();
        String formattedKey = String.format("%s.%s", className, key);
        if (LNG.hasKey((String)formattedKey)) {
            return LNG.get((String)formattedKey, (Object[])args);
        }
        return "<<" + formattedKey + ">>";
    }

    protected final void showErrorMessage(String msg) {
        this.showMessage(msg, 0);
    }

    protected final void showInformation(String msg) {
        this.showMessage(msg, 1);
    }

    private final void showMessage(Object msg, int type) {
        Client client = Client.getInstance();
        String systemName = client.getSystemName();
        DesktopComponentFrame frame = ((DesktopFrame)this.desktop).getDesktopFrame();
        JOptionPane.showMessageDialog(frame, msg, systemName, type);
    }

    protected final void showPanel(JPanel panel) {
        this.showMessage(panel, -1);
    }

    protected final void showWarning(String msg) {
        this.showMessage(msg, 2);
    }

    public DesktopAction(T desktop) {
        if (desktop == null) {
            String err = "null desktop!";
            throw new IllegalArgumentException("null desktop!");
        }
        this.desktop = desktop;
    }
}

