/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.dircontents;

import csbase.client.desktop.dircontents.DirectoryContentsPanel;
import csbase.client.project.action.CommonFileOpenAction;
import csbase.logic.ClientProjectFile;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;

public class DirectoryContentsMouseAdapter
extends MouseAdapter {
    int selectedRow;
    DirectoryContentsPanel dirContentsPanel;
    JTable table;

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int fileColIndex = this.dirContentsPanel.getFileColIndex();
            int row = this.table.getSelectedRow();
            ClientProjectFile file = (ClientProjectFile)this.table.getValueAt(row, fileColIndex);
            if (file.isDirectory()) {
                this.dirContentsPanel.synchronizeSelection(file);
                return;
            }
            CommonFileOpenAction openAction = new CommonFileOpenAction(this.dirContentsPanel);
            openAction.openFile(file);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.showPopupMenu(me);
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.showPopupMenu(me);
        }
    }

    private void showPopupMenu(MouseEvent me) {
        int X = me.getX();
        int Y = me.getY();
        if (this.dirContentsPanel.getSelectionCount() > 1) {
            if (this.dirContentsPanel.getPopupMultSelection() != null) {
                this.dirContentsPanel.configurePopupMultiSelection();
                this.dirContentsPanel.getPopupMultSelection().show(this.table, X, Y);
            }
        } else {
            int row = this.table.rowAtPoint(new Point(X, Y));
            this.table.setRowSelectionInterval(row, row);
            int fileColIndex = this.dirContentsPanel.getFileColIndex();
            ClientProjectFile file = (ClientProjectFile)this.table.getValueAt(row, fileColIndex);
            if (file.isDirectory()) {
                if (this.dirContentsPanel.getPopupDir() != null) {
                    this.dirContentsPanel.configurePopupDir();
                    this.dirContentsPanel.getPopupDir().show(this.table, X, Y);
                }
            } else if (this.dirContentsPanel.getPopupFile() != null) {
                this.dirContentsPanel.configurePopupFile(file);
                this.dirContentsPanel.getPopupFile().show(this.table, X, Y);
            }
        }
    }

    public DirectoryContentsMouseAdapter(DirectoryContentsPanel panel) {
        this.dirContentsPanel = panel;
        this.table = this.dirContentsPanel.getTable();
    }
}

