/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.Client;
import csbase.client.ClientLocalFile;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.LocalTask;
import csbase.client.desktop.RemoteTask;
import csbase.client.ias.Filter;
import csbase.client.kernel.ClientException;
import csbase.client.project.ClientProjectFileType;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.client.project.tasks.CreateFileTask;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.UserOutline;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public final class ExportUsersDialog {
    private static final String EMAILS_SEPARATOR = ";";
    private Window owner;
    private String windowLabel;
    private DesktopComponentDialog window;
    private Container contentPane;
    private JButton prjActionButton;
    private JButton localActionButton;
    private SortableTable sortableTable;
    private static final String FILE_TYPE = "CSV";
    private static final int LOGIN_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int E_MAIL_COLUMN = 2;
    private static final int USERGROUP_COLUMN = 3;
    private static final char FIELD_SEPARATOR = '\t';
    private static final char REGISTER_SEPARATOR = '\n';

    public ExportUsersDialog(Window owner) {
        this.owner = owner;
        this.windowLabel = LNG.get((String)"IAS_EXPORT_USERS_TITLE");
        this.window = new DesktopComponentDialog(owner, this.windowLabel);
        this.window.center(owner);
        this.contentPane = this.window.getContentPane();
    }

    public void showDialog() {
        this.createUsersPanel();
        this.createButtonPanel();
        this.window.pack();
        this.window.setLocationRelativeTo(this.owner);
        this.updateActionButtons();
        this.window.setVisible(true);
    }

    private void createUsersPanel() {
        JPanel usersPanel = new JPanel();
        usersPanel.setLayout(new BorderLayout());
        this.createTable();
        usersPanel.add((Component)new JScrollPane((Component)this.sortableTable), "Center");
        this.contentPane.add((Component)usersPanel, "Center");
    }

    private void createTable() {
        Vector<UserOutline> allOutlines = UserProxy.getAllOutlines(this.owner, this.windowLabel, "MESSAGE");
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                UserOutline line = (UserOutline)item;
                if (line == null) {
                    return null;
                }
                String[] emails = line.getEmails();
                StringBuilder sb = new StringBuilder();
                if (emails != null && emails.length > 0) {
                    String firstEmail = line.getEmails()[0];
                    sb.append(firstEmail);
                    for (int inx = 1; inx < emails.length; ++inx) {
                        sb.append(ExportUsersDialog.EMAILS_SEPARATOR).append(emails[inx]);
                    }
                } else {
                    sb.append("---");
                }
                return new String[]{line.getLogin(), line.getName(), sb.toString(), line.getUserGroup()};
            }

            public String[] getColumnNames() {
                return new String[]{LNG.get((String)"IAS_USER"), LNG.get((String)"IAS_USER_NAME"), LNG.get((String)"IAS_USER_EMAIL"), LNG.get((String)"IAS_USERGROUP")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{String.class, String.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(allOutlines, (ObjectTableProvider)provider);
        this.sortableTable = new SortableTable((TableModel)model);
        this.sortableTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ExportUsersDialog.this.updateActionButtons();
            }
        });
    }

    private void updateActionButtons() {
        if (this.sortableTable.getSelectedRowCount() > 0) {
            this.prjActionButton.setEnabled(true);
            this.localActionButton.setEnabled(true);
        } else {
            this.prjActionButton.setEnabled(false);
            this.localActionButton.setEnabled(false);
        }
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame == null || desktopFrame.getProject() == null) {
            this.prjActionButton.setEnabled(false);
        } else {
            this.prjActionButton.setEnabled(true);
        }
    }

    private void createButtonPanel() {
        this.createProjectActionButton();
        this.createLocalActionButton();
        JButton closeButton = this.createCloseButton();
        ClientUtilities.adjustEqualSizes(this.localActionButton, this.prjActionButton, closeButton);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.localActionButton);
        buttonsPanel.add(this.prjActionButton);
        buttonsPanel.add(closeButton);
        this.contentPane.add((Component)buttonsPanel, "South");
    }

    private void createProjectActionButton() {
        this.prjActionButton = new JButton(LNG.get((String)"IAS_EXPORT_USERS_PRJ_ACTION_BUTTON"));
        this.prjActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExportUsersDialog.this.showProjectFileChooser();
            }
        });
    }

    private void createLocalActionButton() {
        this.localActionButton = new JButton(LNG.get((String)"IAS_EXPORT_USERS_LOCAL_ACTION_BUTTON"));
        this.localActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ExportUsersDialog.this.showFileChooser();
            }
        });
    }

    private void showFileChooser() {
        StringBuffer buffer;
        File file;
        ClientLocalFile clientLocalFile;
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(true);
        fc.addChoosableFileFilter(new Filter("txt", LNG.get((String)"ias.file_type.txt.description")));
        fc.addChoosableFileFilter(new Filter("csv", LNG.get((String)"ias.file_type.csv.description")));
        int returnVal = fc.showSaveDialog(this.window);
        if (returnVal == 0 && this.writeFile(clientLocalFile = new ClientLocalFile(file = fc.getSelectedFile()), buffer = this.generateData())) {
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)LNG.get((String)"IAS_EXPORT_USERS_SUCCESS"));
            this.window.close();
        }
    }

    private boolean writeFile(final ClientFile file, final StringBuffer buffer) {
        LocalTask<Void> localTask = new LocalTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                OutputStream stream = file.getOutputStream();
                Client client = Client.getInstance();
                Charset charset = client.getSystemDefaultCharset();
                OutputStreamWriter writer = new OutputStreamWriter(stream, charset);
                try {
                    writer.write(buffer.toString());
                }
                finally {
                    writer.close();
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof IOException) {
                    StandardDialogs.showErrorDialog((Component)ExportUsersDialog.this.window, (String)ExportUsersDialog.this.windowLabel, (String)String.format(LNG.get((String)"ExportUsersDialog.save.file.failed"), file.getName()));
                } else {
                    super.handleError(error);
                }
            }
        };
        return localTask.execute(this.window, this.windowLabel, String.format(LNG.get((String)"ExportUsersDialog.msg.writing.file"), file.getName()));
    }

    private void showProjectFileChooser() {
        ClientProjectFile clientProjectFile = this.getChosenFile();
        if (clientProjectFile == null) {
            return;
        }
        StringBuffer buffer = this.generateData();
        if (this.writeFile(clientProjectFile, buffer)) {
            StandardDialogs.showInfoDialog((Component)this.window, (String)this.windowLabel, (Object)LNG.get((String)"IAS_EXPORT_USERS_SUCCESS"));
            this.window.close();
        }
    }

    private boolean writeFile(final ClientProjectFile clientProjectFile, final StringBuffer buffer) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void performTask() throws Exception {
                OutputStreamWriter writer = null;
                try {
                    OutputStream stream = clientProjectFile.getOutputStream();
                    writer = new OutputStreamWriter(stream);
                    writer.write(buffer.toString());
                    writer.flush();
                    writer.close();
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof FileLockedException) {
                    StandardDialogs.showErrorDialog((Component)ExportUsersDialog.this.window, (String)ExportUsersDialog.this.windowLabel, (String)String.format(LNG.get((String)"csbase.file.locked.error"), clientProjectFile.getName()));
                } else {
                    super.handleError(error);
                }
            }
        };
        return task.execute(this.window, this.windowLabel, String.format(LNG.get((String)"ExportUsersDialog.msg.writing.file"), clientProjectFile.getName()));
    }

    private ClientProjectFile getChosenFile() {
        CommonClientProject currentProject = DesktopFrame.getInstance().getProject();
        ProjectFileChooserSave chooser = null;
        String fileTypeExt = FILE_TYPE;
        ClientProjectFileType projFileType = ClientProjectFileType.getFileType(FILE_TYPE);
        if (projFileType.getCode().equals("UNKNOWN")) {
            fileTypeExt = "TEXT";
        }
        try {
            chooser = new ProjectFileChooserSave(this.window, currentProject, 0, fileTypeExt);
        }
        catch (ClientException ce) {
            StandardErrorDialogs.showErrorDialog(this.window, this.windowLabel, LNG.get((String)"ExportUsersDialog.error.creating.chooser"), ce);
            return null;
        }
        ProjectTreePath treePath = chooser.getSelectedPath();
        if (treePath == null) {
            return null;
        }
        if (treePath.exists()) {
            return treePath.getFile();
        }
        String[] path = treePath.getPath();
        String name = path[path.length - 1];
        CreateFileTask task = new CreateFileTask(currentProject, treePath.getParent(), name, chooser.getFileType());
        boolean succeeded = task.execute(this.window, this.windowLabel, String.format(LNG.get((String)"ExportUsersDialog.msg.creating.file"), name));
        if (succeeded) {
            return (ClientProjectFile)task.getResult();
        }
        return null;
    }

    private StringBuffer generateData() {
        StringBuffer buffer = new StringBuffer();
        int[] selectedRows = this.sortableTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            String login = (String)this.sortableTable.getValueAt(selectedRows[i], 0);
            String name = (String)this.sortableTable.getValueAt(selectedRows[i], 1);
            String eMail = (String)this.sortableTable.getValueAt(selectedRows[i], 2);
            String userGroup = (String)this.sortableTable.getValueAt(selectedRows[i], 3);
            buffer.append(login);
            buffer.append('\t');
            buffer.append(name);
            buffer.append('\t');
            buffer.append(eMail);
            buffer.append('\t');
            buffer.append(userGroup);
            buffer.append('\n');
        }
        return buffer;
    }

    private JButton createCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.setEnabled(true);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportUsersDialog.this.window.close();
            }
        });
        return closeButton;
    }
}

