/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.tasks;

import csbase.client.project.ClientProjectFileProperties;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import tecgraf.javautils.core.lng.LNG;

public class FileTypeIconCellRenderer
extends DefaultTableCellRenderer {
    private static final String DIR_LABEL = LNG.get((String)"DIR_CONTENTS_DIRECTORY");

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ImageIcon icon = null;
        ClientProjectFile file = null;
        if (value != null) {
            file = (ClientProjectFile)value;
            icon = ClientProjectFileProperties.getImageIcon(file);
            this.setToolTipText(this.getType(file));
        }
        this.setIcon(icon);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        return this;
    }

    private String getType(ClientProjectFile file) {
        if (file.isDirectory()) {
            return DIR_LABEL;
        }
        return ProjectFileType.getFileType((String)file.getType()).getDescription();
    }
}

