/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.menu;

import csbase.client.util.csvpanel.table.CSVTable;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.core.lng.LNG;

public abstract class CSVTablePopupMenu
extends JPopupMenu {
    protected int popupRow;
    protected int popupCol;
    protected CSVTable table;

    public CSVTablePopupMenu(CSVTable table) {
        this.table = table;
    }

    protected void setPopupLocation(Point p) {
        this.popupRow = this.table.getRowCount() == 0 ? 0 : this.table.rowAtPoint(p);
        TableColumnModel columnModel = this.table.getColumnModel();
        this.popupCol = columnModel.getColumnIndexAtX((int)p.getX());
    }

    protected String getString(String key) {
        return LNG.get((String)(this.getClass().getName() + "." + key));
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this.setPopupLocation(new Point(x, y));
        if (this.shouldBeShown()) {
            this.updateItemStatus();
            super.show(invoker, x, y);
        }
    }

    protected boolean shouldBeShown() {
        return this.popupCol >= 0 && this.popupRow >= 0;
    }

    protected abstract void updateItemStatus();
}

