/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.filechooser.filetablepanel;

import csbase.client.desktop.Task;
import csbase.client.util.filechooser.ClientFileChooser;
import csbase.client.util.filechooser.filters.ClientFileAllFilter;
import csbase.client.util.filechooser.filters.ClientFileFilterInterface;
import csbase.client.util.filechooser.util.ClientFileChooserUtils;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import tecgraf.javautils.core.lng.LNG;

class ClientFileTableModel
extends AbstractTableModel {
    private final List<ClientFile> list = new ArrayList<ClientFile>();
    private ClientFile clientFile;
    private ClientFileFilterInterface filter;
    private final String[] colunms;
    private boolean showHiddenFiles;
    private final Component parent;

    public ClientFileTableModel(ClientFile file, ClientFileAllFilter filter, Component parent) {
        String typeText = this.getString("type.column");
        String nameText = this.getString("name.column");
        String sizeText = this.getString("size.column");
        String modifiedText = this.getString("modified.column");
        this.colunms = new String[]{typeText, nameText, sizeText, modifiedText};
        this.clientFile = file;
        this.filter = filter;
        this.parent = parent;
        this.refresh();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return ClientFile.class;
    }

    @Override
    public final int getColumnCount() {
        return this.colunms.length;
    }

    @Override
    public final String getColumnName(int col) {
        return this.colunms[col];
    }

    public final ClientFile getDirectory() {
        return this.clientFile;
    }

    public final List<ClientFile> getFileList() {
        return this.list;
    }

    public final ClientFileFilterInterface getFilter() {
        return this.filter;
    }

    @Override
    public final int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    private final String getString(String tag) {
        Class<ClientFileChooser> clazz = ClientFileChooser.class;
        String prefix = clazz.getSimpleName();
        return LNG.get((String)(prefix + "." + tag));
    }

    public final ClientFile getValueAt(int row, int col) {
        if (row < 0) {
            return null;
        }
        ClientFile f = this.list.get(row);
        return f;
    }

    public final List<ClientFile> getFilesWithPrefix(String prefix) {
        ArrayList<ClientFile> files = new ArrayList<ClientFile>();
        if (prefix != null) {
            for (ClientFile file : this.list) {
                String fileName = file.getName().toLowerCase();
                if (!fileName.startsWith(prefix.toLowerCase())) continue;
                files.add(file);
            }
        }
        return files;
    }

    public final void refresh() {
        boolean executed;
        ClientFile[] children;
        this.list.clear();
        if (this.clientFile == null) {
            return;
        }
        Task<ClientFile[]> task = new Task<ClientFile[]>(){

            protected void performTask() throws Exception {
                ClientFile[] children = ClientFileTableModel.this.clientFile.getChildren();
                this.setResult(children);
            }
        };
        String taskMessage = this.clientFile.getName();
        String taskTitle = "";
        Window window = null;
        if (this.parent != null) {
            window = SwingUtilities.getWindowAncestor(this.parent);
        }
        if ((children = !(executed = task.execute(window, "", taskMessage)) || task.getError() != null ? null : (ClientFile[])task.getResult()) != null) {
            for (ClientFile f : children) {
                boolean isHidden = ClientFileChooserUtils.isHiddenFile(f);
                if (!this.showHiddenFiles && isHidden || !this.filter.accept(f)) continue;
                this.list.add(f);
            }
        }
        this.fireTableDataChanged();
    }

    public final void setDirectory(ClientFile file) {
        this.clientFile = file;
        this.refresh();
    }

    public final void setFilter(ClientFileFilterInterface filter) {
        this.filter = filter;
        this.refresh();
    }

    public final void showHiddenFiles(boolean flag) {
        this.showHiddenFiles = flag;
        this.refresh();
    }

    public final boolean isHiddenFilesShown() {
        return this.showHiddenFiles;
    }
}

