/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.iostring;

import csbase.client.Client;
import csbase.client.util.iostring.ReaderTask;
import csbase.client.util.iostring.TextDealerStatusInterface;
import csbase.logic.ClientFile;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import tecgraf.javautils.core.lng.LNG;

public class TextReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readAllWithoutTask(ClientFile file, Charset charset, TextDealerStatusInterface dealerStatus) throws IOException {
        Charset readCharset;
        if (charset == null) {
            Client client = Client.getInstance();
            readCharset = client.getSystemDefaultCharset();
        } else {
            readCharset = charset;
        }
        if (file == null || file.isDirectory()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            long fileSize = file.size();
            if (fileSize > Integer.MAX_VALUE) {
                throw new IOException("file too big");
            }
            int totalBytes = (int)fileSize;
            StringBuilder stringBuilder = new StringBuilder(totalBytes);
            InputStream stream = file.getInputStream();
            InputStreamReader rd = new InputStreamReader(stream, readCharset);
            reader = new BufferedReader(rd);
            char[] buffer = new char[10240];
            int readBytes = 0;
            int nbytes = reader.read(buffer);
            readBytes += nbytes;
            while (nbytes > 0) {
                if (dealerStatus != null && dealerStatus.isTextOperationInterrupted()) {
                    String string = null;
                    return string;
                }
                stringBuilder.append(buffer, 0, nbytes);
                nbytes = reader.read(buffer);
                double perc = (double)(readBytes += nbytes) / (double)totalBytes * 100.0;
                int percentage = (int)Math.round(perc);
                if (dealerStatus == null) continue;
                dealerStatus.setTextOperationPercentage(percentage);
            }
            if (dealerStatus != null) {
                dealerStatus.setTextOperationPercentage(100);
            }
            reader.close();
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static String readAllWithTask(Window owner, ClientFile file, Charset charset) throws Exception {
        ReaderTask task = new ReaderTask(file, charset);
        String msg = LNG.get((String)"TextReader.task.message");
        if (!task.execute(owner, "", msg = msg + " (" + file.getName() + ")", true, false)) {
            Exception error = task.getError();
            if (error != null) {
                throw error;
            }
            return "";
        }
        String str = (String)task.getResult();
        return str;
    }
}

