/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.iostring;

import csbase.client.Client;
import csbase.client.util.iostring.TextDealerStatusInterface;
import csbase.client.util.iostring.WriterTask;
import csbase.logic.ClientFile;
import java.awt.Window;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import tecgraf.javautils.core.lng.LNG;

public class TextWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllWithoutTask(ClientFile file, String text, Charset charset, TextDealerStatusInterface statusDealer) throws IOException {
        Charset writeCharset;
        if (charset == null) {
            Client client = Client.getInstance();
            writeCharset = client.getSystemDefaultCharset();
        } else {
            writeCharset = charset;
        }
        int totalBytes = text.length();
        int wroteBytes = 0;
        OutputStream stream = file.getOutputStream();
        OutputStreamWriter streamWriter = new OutputStreamWriter(stream, writeCharset);
        BufferedWriter writer = new BufferedWriter(streamWriter);
        int blockSize = 102400;
        try {
            while (wroteBytes < totalBytes) {
                if (statusDealer != null && statusDealer.isTextOperationInterrupted()) {
                    return;
                }
                int endIndex = wroteBytes + 102400;
                if (endIndex > totalBytes) {
                    endIndex = totalBytes;
                }
                String strDump = text.substring(wroteBytes, endIndex);
                char[] charArray = strDump.toCharArray();
                writer.write(charArray, 0, charArray.length);
                double perc = (double)(wroteBytes += charArray.length) / (double)totalBytes * 100.0;
                int percentage = (int)Math.round(perc);
                if (statusDealer == null) continue;
                statusDealer.setTextOperationPercentage(percentage);
            }
            if (statusDealer != null) {
                statusDealer.setTextOperationPercentage(100);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void writeAllWithTask(Window owner, ClientFile file, String content, Charset charset) throws Exception {
        Exception error;
        Charset writeCharset;
        if (charset == null) {
            Client client = Client.getInstance();
            writeCharset = client.getSystemDefaultCharset();
        } else {
            writeCharset = charset;
        }
        WriterTask task = new WriterTask(file, content, writeCharset);
        String msg = LNG.get((String)"TextWriter.task.message");
        msg = msg + " (" + file.getName() + ")";
        if (!task.execute(owner, "", msg) && (error = task.getError()) != null) {
            throw error;
        }
    }
}

