/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.models;

/**
 * Informaes necessrias para a criao de uma coluna utilizada em uma tabela
 * de comandos.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ColumnDTO {

  /** Identificador nico da coluna. */
  private String id;
  /**
   * Nome da classe que modela a coluna. <br>
   * Ela deve estender
   * {@link csbase.client.applications.commandsmonitor.table.column.AbstractCommandsTableColumn}.
   */
  private String className;

  /**
   * Construtor.
   * 
   * @param id Identificador nico da coluna.
   * @param className Nome da classe que modela a coluna.
   */
  public ColumnDTO(String id, String className) {
    super();
    this.id = id;
    this.className = className;
  }

  /**
   * Obtm o identificador nico da coluna.
   * 
   * @return O identificador nico da coluna.
   */
  public String getId() {
    return id;
  }

  /**
   * Obtm o nome da classe que modela a coluna.
   * 
   * @return O nome da classe que modela a coluna.
   */
  public String getColumnClassName() {
    return className;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((id == null) ? 0 : id.hashCode());
    return result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    final ColumnDTO other = (ColumnDTO) obj;
    if (id == null) {
      if (other.id != null)
        return false;
    }
    else if (!id.equals(other.id))
      return false;
    return true;
  }
}
