/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

/**
 * Renderiza clulas acressentando um % aps o valor.<br>
 * O valor das clulas deve ser do tipo {@link Double}.
 * 
 * @author Tecgraf / PUC-Rio
 */
class PercentageTableCellRenderer extends DefaultTableCellRenderer {

  /**
   * Valor padro.
   */
  private String empty_value;

  /**
   * Construtor.
   * 
   * @param empty_value valor padro a ser utilizado quando o valor da clula
   *        for {@code null}.
   */
  PercentageTableCellRenderer(String empty_value) {
    this.empty_value = empty_value;
  }

  /**
   * Renderiza uma clula acressentando um % aps o valor. Caso o valor seja
   * {@code null}, empty_value ser retornado no lugar.<br>
   * O valor das clulas deve ser do tipo {@link Double}.
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {

    super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
      row, column);

    if (value == null) {
      setText(empty_value);
    }
    else {
      String text = ((Double) value).intValue() + " %";
      setText(text);
    }
    return this;
  }
}
