package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphLayout;
import csbase.client.applications.flowapplication.graph.SingleColumnGraphLayout;

/**
 * Ao de aplicar o {@link SingleColumnGraphLayout} no fluxo corrente.
 */
public class SingleColumnGraphLayoutAction extends GraphLayoutAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public SingleColumnGraphLayoutAction(FlowApplication application) {
    super(application, FlowApplicationUI.SINGLE_COLUMN_LAYOUT_ICON,
      new SingleColumnGraphLayout());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean usePreview() {
    FlowApplication application = getApplication();
    Workspace workspace = application.getWorkspace();
    Graph graph = workspace.getGraph();
    GraphLayout layout = getLayout();
    return !layout.canApplyLayout(graph);
  }

}
