/**
 * $Id: ProjectListTableModel.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.applications.projectsmanager.dialogs;

import java.util.Collections;
import java.util.List;

import javax.swing.table.DefaultTableModel;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Modelo para tabelas que exibem uma lista de projetos definidos por uma lista
 * de {@link ProjectsManagerData}.
 * 
 * @author Tecgraf
 */
class ProjectListTableModel extends DefaultTableModel {
  /**
   * Lista com os nomes das colunas.
   */
  private static String[] COL_NAMES = {
      LNG.get("ProjectListTableModel.header.user"),
      LNG.get("ProjectListTableModel.header.project") };
  /**
   * Informaes sobre os projetos.
   */
  private final List<ProjectsManagerData> prjData;
  /**
   * Nmero de linhas da tabela.
   */
  private final int numRows;

  /**
   * Construtor.
   * 
   * @param projectsRW - informaes sobre os projetos
   */
  public ProjectListTableModel(final List<ProjectsManagerData> projectsRW) {
    /*
     * garantimos que a lista  invariante...
     */
    this.prjData = Collections.unmodifiableList(projectsRW);
    numRows = prjData.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int col) {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getColumnCount() {
    return COL_NAMES.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName(int col) {
    return COL_NAMES[col];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getRowCount() {
    return numRows;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValueAt(int row, int col) {
    if (col == 0) {
      return prjData.get(row).getOwnerName();
    }
    return prjData.get(row).getProjectName();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isCellEditable(int arg0, int arg1) {
    return false;
  }

  /**
   * Retorna o projeto associado a uma determinada linha da tabela.
   * 
   * @param row - linha da tabela, em coordenadas do <b>modelo</b>
   * 
   * @return projeto associado  linha especificada da tabela
   */
  public ProjectsManagerData getProject(final int row) {
    return prjData.get(row);
  }

}
