package csbase.client.applications.projectsynchronization;

import csbase.logic.ProjectSynchronizationFileInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

import tecgraf.javautils.gui.wizard.History;
import tecgraf.javautils.gui.wizard.WizardException;

import java.awt.Container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class StepSelectionFiles extends StepProjectSynchronization {
  protected ContainerSelectionFiles containerSelectionFiles;
  protected ApplicationRegistry registry;
  protected String serverNameA;
  protected String projectNameA;
  protected String serverNameB;
  protected String projectNameB;

  StepSelectionFiles(ApplicationRegistry registry) {
    this.registry = registry;
    containerSelectionFiles = new ContainerSelectionFiles(registry);
  }

  protected void enter(History history)
  throws WizardException {
    serverNameA = (String)history.get(null, "serverNameA");
    projectNameA = (String)history.get(null, "projectNameA");
    serverNameB = (String)history.get(null, "serverNameB");
    projectNameB = (String)history.get(null, "projectNameB");
  }

  /**
   * Completa os items no ContainerSelectionFiles. Recebe um map de todos
   * arquivos e uma lista de arquivos que devem ser ignorados. Essa lista 
   * usada ao selecionar os arquivos do projeto B a serem copiados para o
   * projeto A. Caso um arquivo de A tenha sido selecionado para ser copiado
   * para o projeto B, o mesmo no deve aparecer disponvel na lista de
   * arquivos do projeto B para serem copiados para o projeto A. Nesse caso
   * seria uma copia circular.
   *
   * @param map Lista de todos ProjectSynchronizationFileInfo
   * @param excludeItems Lista com os nomes dos arquivos selecionados do
   *        projeto A para serem copiados para o projeto B
   */
  protected void completeContainerSelection(Map map, List excludeItems) {
    ArrayList<ProjectSynchronizationFileInfo> items =
      new ArrayList<ProjectSynchronizationFileInfo>();
    ArrayList<ProjectSynchronizationFileInfo> selectedItems =
      new ArrayList<ProjectSynchronizationFileInfo>();
    for (Iterator i = map.values().iterator(); i.hasNext();) {
      ProjectSynchronizationFileInfo psfi =
        (ProjectSynchronizationFileInfo)i.next();
      if (
        (excludeItems == null) ||
        (excludeItems.contains(psfi.generateAbsoluteFilename()) == false)) {
        if (psfi.getTransfer()) {
          selectedItems.add(psfi);
        }
        else {
          items.add(psfi);
        }
      }
    }
    containerSelectionFiles.getContainerSelection()
    .loadItems(items, selectedItems);
  }

  protected Container getContainer() {
    return containerSelectionFiles.getRootPanel();
  }

  /**
   * Altera o status Transfer de todos ProjectSynchronizationFileInfo de
   * acordo com a seleo no ContainerSelectionFiles. Gera tambm uma lista de
   * strings com todos nomes dos arquivos selecionados
   *
   * @param map .
   *
   * @return List
   */
  protected List<String> confirmSelection(Map map) {
    List<String> selectedItems = new ArrayList<String>();
    for (Iterator i = map.values().iterator(); i.hasNext();) {
      ProjectSynchronizationFileInfo psfi =
        (ProjectSynchronizationFileInfo)i.next();
      psfi.setTransfer(false);
    }
    List list =
      containerSelectionFiles.getContainerSelection().getSelectedItems();
    for (Iterator i = list.iterator(); i.hasNext();) {
      ProjectSynchronizationFileInfo psfi =
        (ProjectSynchronizationFileInfo)i.next();
      psfi.setTransfer(true);
      selectedItems.add(psfi.generateAbsoluteFilename());
    }
    return selectedItems;
  }
}
