package csbase.client.applications.statsviewer;

import java.awt.CardLayout;
import java.awt.GridBagLayout;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import tecgraf.javautils.gui.GBC;
import csbase.client.applications.statsviewer.LogsView.LogsDataType;
import csbase.client.applications.statsviewer.graphic.AlgorithmsDatePanel;
import csbase.client.applications.statsviewer.graphic.ApplicationsDatePanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsAlgorithmPanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsDatePanel;
import csbase.client.applications.statsviewer.graphic.ExecutionsUsersPanel;
import csbase.client.applications.statsviewer.graphic.GraphicPanel;
import csbase.client.applications.statsviewer.graphic.LoginsDatePanel;
import csbase.client.applications.statsviewer.graphic.LoginsUsersPanel;

/**
 * Painelque exibe os grficos em abas conforme as estatsticas de interesse.
 *
 * @author Tecgraf/PUC-Rio
 */
public class GraphicTabsPanel extends JPanel {

  /**
   * Referncia para aplicao.
   */
  private StatsViewer appViewer;

  /**
   * Painel com cardLayout conforme os tipos de estatsticas.
   */
  private JPanel cardsPanel;

  /**
   * Construtor.
   *
   * @param appViewer referncia para aplicao
   */
  public GraphicTabsPanel(StatsViewer appViewer) {
    super(new GridBagLayout());
    this.appViewer = appViewer;

    GBC gbc = new GBC(0, 0).northwest().insets(5).both();
    add(buildCardsPanel(), gbc);
  }

  /**
   * @return painel para exibir os resultados em forma de grficos.
   */
  private JPanel buildCardsPanel() {

    cardsPanel = new JPanel(new CardLayout());

    JTabbedPane loginTabbedPane = new JTabbedPane();

    // LOGIN Tab 0
    String title = appViewer.getString("login.date.title");
    String tabtitle = appViewer.getString("login.date.tab");
    GraphicPanel graphicPanel = new LoginsDatePanel(appViewer, title);
    loginTabbedPane.addTab(tabtitle, graphicPanel);

    // LOGIN Tab 1
    title = appViewer.getString("login.users.title");
    tabtitle = appViewer.getString("login.users.tab");
    graphicPanel = new LoginsUsersPanel(appViewer, title);
    loginTabbedPane.addTab(tabtitle, graphicPanel);

    JTabbedPane applicationsTabbedPane = new JTabbedPane();

    // APPLICATIONS Tab 0
    title = appViewer.getString("applications.date.title");
    tabtitle = appViewer.getString("applications.date.tab");
    graphicPanel = new ApplicationsDatePanel(appViewer, title);
    applicationsTabbedPane.addTab(tabtitle, graphicPanel);

    JTabbedPane executionsTabbedPane = new JTabbedPane();

    // EXECUTIONS Tab 0
    title = appViewer.getString("executions.users.title");
    tabtitle = appViewer.getString("executions.users.tab");
    graphicPanel = new ExecutionsUsersPanel(appViewer, title);
    executionsTabbedPane.addTab(tabtitle, graphicPanel);

    // EXECUTIONS Tab 1
    title = appViewer.getString("executions.algorithm.title");
    tabtitle = appViewer.getString("executions.algorithm.tab");
    graphicPanel = new ExecutionsAlgorithmPanel(appViewer, title);
    executionsTabbedPane.addTab(tabtitle, graphicPanel);

    // EXECUTIONS Tab 2
    title = appViewer.getString("algorithms.date.title");
    tabtitle = appViewer.getString("algorithms.date.tab");
    graphicPanel = new AlgorithmsDatePanel(appViewer, title);
    executionsTabbedPane.addTab(tabtitle, graphicPanel);

    // EXECUTIONS Tab 3
    title = appViewer.getString("executions.date.title");
    tabtitle = appViewer.getString("executions.date.tab");
    graphicPanel = new ExecutionsDatePanel(appViewer, title);
    executionsTabbedPane.addTab(tabtitle, graphicPanel);

    cardsPanel.add(loginTabbedPane, LogsDataType.LoginData.name());
    cardsPanel
    .add(applicationsTabbedPane, LogsDataType.ApplicationsData.name());
    cardsPanel.add(executionsTabbedPane, LogsDataType.ExecutionsData.name());

    return cardsPanel;
  }

  /**
   * Atualiza o painel conforme o tipo de estatstica de interesse selecionado.
   *
   * @param selectedType tipo de estatstica selecionada
   */
  public void setLogType(LogsDataType selectedType) {
    CardLayout cl = (CardLayout) (cardsPanel.getLayout());
    cl.show(cardsPanel, selectedType.name());
  }

}