package csbase.client.applications.statsviewer.graphic;

import java.util.Observable;

import csbase.client.applications.statsviewer.LogsView;
import csbase.client.applications.statsviewer.StatsViewer;

/**
 * Painel que exibe o grfico com os logins realizados pelos usurios (exibe
 * apenas as 10 maiores ocorrncias, desconsiderando o usurio admin).
 */
public class LoginsUsersPanel extends GraphicPanel {

  /**
   * Construtor do painel LoginUserPanel.
   *
   * @param app referncia para a aplicao que iniciou o painel
   * @param title ttulo do grfico
   */
  public LoginsUsersPanel(final StatsViewer app, String title) {
    super(app, title);
    newBarChart3DPanel(app.getString("users"), app.getString("logins.number"),
      false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void update(Observable appObservable, Object view) {
    LogsView infoView = (LogsView) view;
    updateSubTitle(infoView.getInfo());
    updateSimpleDataSet(infoView.getTop10UserLogins(), app.getString("user"));
  }

}
