package csbase.client.csdk.v1_0;

import java.util.HashMap;
import java.util.Map;

import csbase.client.csdk.v1_0.application.CSDKApplicationContext;
import csbase.client.csdk.v1_0.command.CSDKCommandContext;
import csbase.client.csdk.v1_0.extras.user.CSDKUserContext;
import csbase.client.csdk.v1_0.filesystem.CSDKLocalFileSystemContext;
import csbase.client.csdk.v1_0.filesystem.CSDKProjectContext;
import csbase.client.csdk.v1_0.openbus.OpenBusContext;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.command.ICommandContext;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.api.filesystem.project.IProjectContext;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.extras.context.IOpenBusContext;

/**
 * Fbrica padro de contextos para o CSDK 1.0.
 */
public class DefaultCSDKContextFactory implements CSDKContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId, Class<? extends IApplication> mainClass,
    ApplicationRegistry registry) {
    Map<Class<? extends IContext>, IContext> contexts =
      new HashMap<Class<? extends IContext>, IContext>();
    contexts.put(IApplicationContext.class, new CSDKApplicationContext(
      instanceId, mainClass, registry));
    contexts.put(IProjectContext.class, new CSDKProjectContext(registry));
    contexts.put(ILocalFileSystemContext.class, new CSDKLocalFileSystemContext(
      registry));
    contexts.put(ICommandContext.class, new CSDKCommandContext());
    contexts.put(IOpenBusContext.class, new OpenBusContext());
    contexts.put(IUserContext.class, new CSDKUserContext());

    return contexts;
  }
}
