/*
 * $Id: ShowHiddenFilesAction.java 150777 2014-03-19 14:16:56Z oikawa $
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;

import javax.swing.JCheckBoxMenuItem;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.logic.CommonClientProject;

/**
 * Ao de exibio / ocultao de arquivos ocultos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ShowHiddenFilesAction extends ProjectAction {

  /**
   * O nome da ao.
   */
  private static final String ACTION_NAME = LNG
    .get("ShowHiddenFilesAction.name");

  /**
   * Construtor.
   * 
   * @param treeView - rvore do projeto
   */
  public ShowHiddenFilesAction(ProjectTree treeView) {
    super(treeView);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    final JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem) e.getSource();
    DesktopFrame.getInstance().setShowHiddenFiles(menuItem.isSelected());
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        CommonClientProject currentProject = getCurrentProject();
        if (currentProject != null) {
          currentProject.refreshTree();
        }
      }
    };

    task.execute(getWindow(), getTitle(), LNG.get("PRJ_WAITING_REFRESH_TREE"));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return ACTION_NAME;
  }
}
