package csbase.client.project.tasks;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.project.ClientProjectFileProperties;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;

/**
 * Renderizador para tipo de arquivo, representado pelo cone associado ao tipo.
 * O tooltip da clula ser a descrio do tipo de arquivo.
 * 
 * @author tatimf
 */
public class FileTypeIconCellRenderer extends DefaultTableCellRenderer {

  /** Label para identificar diretrios. */
  private static final String DIR_LABEL = LNG.get("DIR_CONTENTS_DIRECTORY");

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTableCellRendererComponent(JTable table, Object value,
    boolean isSelected, boolean hasFocus, int row, int column) {
    ImageIcon icon = null;
    ClientProjectFile file = null;
    if (value != null) {
      file = (ClientProjectFile) value;
      icon = ClientProjectFileProperties.getImageIcon(file);
      setToolTipText(getType(file));
    }
    setIcon(icon);

    if (isSelected) {
      setBackground(table.getSelectionBackground());
    }
    else {
      setBackground(table.getBackground());
    }
    return this;
  }

  /**
   * Obtm o tipo do arquivo.
   * 
   * @param file arquivo.
   * 
   * @return tipo do arquivo.
   */
  private String getType(final ClientProjectFile file) {
    if (file.isDirectory()) {
      return DIR_LABEL;
    }
    return ProjectFileType.getFileType(file.getType()).getDescription();
  }

}
