/*
 * UserGroupProxy.java $Author: oikawa $ $Revision: 150777 $ - $Date: 2008-02-11
 * 18:35:52 -0200 (Mon, 11 Feb 2008) $
 */
package csbase.client.remote.srvproxies;

import java.awt.Window;
import java.util.Vector;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.UserGroup;
import csbase.logic.UserGroupInfo;

/**
 * Classe que modela um proxy para UserGroup.
 * 
 * @author Julia
 */
public class UserGroupProxy {
  /**
   * Obtem a lista de grupos de usurios cadastradas. TODO - Mudar tipo de
   * retorno para List<UserGroup>
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janel
   * @param message mensagem exibida na janela
   * 
   * @return o vetor de UserGroups.
   */
  public static Vector<UserGroup> getAllUserGroups(Window owner, String title,
    String message) {
    RemoteTask<Vector<UserGroup>> task = new RemoteTask<Vector<UserGroup>>() {
      @Override
      public void performTask() throws Exception {
        setResult(new Vector<UserGroup>(UserGroup.getAllUserGroups()));
      }
    };
    if (task.execute(owner, title, message)) {
      Vector<UserGroup> userGroupsVector = task.getResult();
      if ((userGroupsVector == null) || (userGroupsVector.size() <= 0)) {
        return new Vector<UserGroup>();
      }
      return userGroupsVector;
    }
    return new Vector<UserGroup>();
  }

  /**
   * Obtm um UserGroup com uma dada identificao.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela
   * @param message mensagem exibida na janela
   * @param userGroupId o identificador da UserGroup
   * 
   * @return o UserGroup requisitado.
   */
  public static UserGroup getUserGroup(Window owner, String title,
    String message, final Object userGroupId) {
    RemoteTask<UserGroup> task = new RemoteTask<UserGroup>() {
      @Override
      public void performTask() throws Exception {
        setResult(UserGroup.getUserGroup(userGroupId));
      }
    };
    if (task.execute(owner, title, message)) {
      return task.getResult();
    }
    return null;
  }

  /**
   * Obtm o grupo de usurios a partir do nome
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela associada.
   * @param message mensagem exibida na janela da task
   * @param name nome do grupo de usurios
   * @return grupo de usurios ou null caso nenhum grupo seja encontrado com o
   *         nome dado
   */
  public static UserGroup getUserGroupByName(Window owner, String title,
    String message, final String name) {
    RemoteTask<UserGroup> task = new RemoteTask<UserGroup>() {
      @Override
      public void performTask() throws Exception {
        setResult(UserGroup.getUserGroupByName(name));
      }
    };
    if (task.execute(owner, title, message)) {
      return task.getResult();
    }
    return null;
  }

  /**
   * Cria um UserGroup.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela
   * @param message mensagem exibida na janela
   * @param info As informaes do novo UserGroup
   * 
   * @return o UserGroup criado.
   */
  public static UserGroup createUserGroup(Window owner, String title,
    String message, final UserGroupInfo info) {
    RemoteTask<UserGroup> task = new RemoteTask<UserGroup>() {
      @Override
      public void performTask() throws Exception {
        setResult(UserGroup.createUserGroup(info));
      }
    };
    if (task.execute(owner, title, message)) {
      UserGroup userGroup = task.getResult();
      if (userGroup == null) {
        StandardErrorDialogs.showErrorDialog(owner, title,
          LNG.get("IAS_USERGROUP_ALREADY_EXISTS_ERROR"));
      }
      return userGroup;
    }
    return null;
  }

  /**
   * Modifica um UserGroup.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela
   * @param message mensagem exibida na janela
   * @param userGroupId o identificador do UserGroup a ser alterado.
   * @param info As informaes de modificao do UserGroup.
   * 
   * @return O UserGroup modificado.
   */
  public static UserGroup modifyUserGroup(Window owner, String title,
    String message, final Object userGroupId, final UserGroupInfo info) {
    RemoteTask<UserGroup> task = new RemoteTask<UserGroup>() {
      @Override
      public void performTask() throws Exception {
        setResult(UserGroup.modifyUserGroup(userGroupId, info));
      }
    };
    if (task.execute(owner, title, message)) {
      UserGroup userGroup = task.getResult();
      if (userGroup == null) {
        StandardErrorDialogs.showErrorDialog(owner, title,
          LNG.get("IAS_USERGROUP_ALREADY_EXISTS_ERROR"));
      }
      return userGroup;
    }
    return null;
  }

  /**
   * Remove um UserGroup.
   * 
   * @param owner janela pai para efeito de hierarquia de dilogos.
   * @param title titulo da janela
   * @param message mensagem exibida na janela
   * @param userGroupId o identificador do UserGroup a ser removido.
   */
  public static void deleteUserGroup(Window owner, String title,
    String message, final Object userGroupId) {
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        UserGroup.deleteUserGroup(userGroupId);
      }
    };
    task.execute(owner, title, message);
  }
}
