/**
 * $Id$
 */
package csbase.client.util;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import csbase.client.applications.projectsmanager.usersearch.UserPanel;
import csbase.logic.UserOutline;

/**
 * 
 * 
 * @author Tecgraf
 */
public class SharedObjectUserPanel extends UserPanel {

  /**
   * Checkbox que define se todos os usurios tem acesso global ao objeto
   */
  private JCheckBox globalCheck;

  /**
   * @param allUsers
   * @param showPermissions
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers,
    boolean showPermissions) {
    super(allUsers, showPermissions);
  }

  /**
   * @param allUsers
   * @param usersRO
   * @param usersRW
   * @param showPermissions
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers, Set<Object> usersRO,
    Set<Object> usersRW, boolean showPermissions) {
    super(allUsers, usersRO, usersRW, showPermissions);
  }

  /**
   * @param allUsers
   * @param usersRO
   * @param usersRW
   * @param showPermissions
   * @param fixedAccess
   */
  public SharedObjectUserPanel(List<UserOutline> allUsers, Set<Object> usersRO,
    Set<Object> usersRW, boolean showPermissions, boolean fixedAccess) {
    super(allUsers, usersRO, usersRW, showPermissions, fixedAccess);
  }

  /**
   * 
   * {@inheritDoc}
   */
  @Override
  protected JPanel createSharedUsersPanel() {
    JPanel wrapperPanel = new JPanel(new GridBagLayout());
    JPanel panel = super.createSharedUsersPanel();
    GBC gbc = new GBC(0, 0).northwest().insets(5, 15, 0, 0);
    globalCheck = new JCheckBox();
    globalCheck.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        sharedUsersTable.enableReadingOnlyForAll(globalCheck.isSelected());
      }
    });
    globalCheck.setText(LNG.get("SharedObjectUserPanel.globalCheck.label"));
    wrapperPanel.add(globalCheck, gbc);
    gbc = new GBC(0, 1).northwest().insets(5, 15, 0, 0).both();
    wrapperPanel.add(panel, gbc);
    return wrapperPanel;
  }

  /**
   * Retorn true se e somente se, o usurio escolheu leitura permitida para
   * todos os usurios
   * 
   * @return true se e somente se, o usurio escolheu leitura permitida para
   *         todos os usurios
   */
  public boolean isGlobal() {
    return globalCheck.isSelected();
  }

  /**
   * Atribui o valor de permisso para todos os usurios apropriadamente
   * 
   * @param isGlobal
   */
  public void setGlobal(boolean isGlobal) {
    globalCheck.setSelected(isGlobal);
    if (isGlobal) {
      sharedUsersTable.enableReadingOnlyForAll(isGlobal);
    }
  }
}
