/*
 * $Id: DirectoryChooserSelectionListener.java,v 1.2 2010/06/15 03:04:23 clinio
 * Exp $
 */
package csbase.client.util.filechooser;

import java.util.ArrayList;
import java.util.List;

import csbase.client.util.filechooser.filetablepanel.ClientFileTablePanel;
import csbase.client.util.filechooser.filetablepanel.ClientFileTableSelectionListener;
import csbase.logic.ClientFile;

/**
 * Listener de mouse
 * 
 * @author Tecgraf/PUC-Rio
 */
class ClientFileChooserSelectionListener implements
  ClientFileTableSelectionListener {

  /**
   * Chooser
   */
  final private ClientFileChooser chooser;

  /**
   * {@inheritDoc}
   */
  @Override
  public void selectionPerformed(ClientFileTablePanel panel,
    List<ClientFile> selectionList) {
    final ClientFileChooserType type = chooser.getSelectionType();
    switch (type) {
      case SAVE:
        handleSaveType(selectionList);
        break;
      case OPEN:
        handleOpenType(selectionList);
        break;
    }
  }

  /**
   * Tratador de modo SAVE
   * 
   * @param selectionList a lista.
   */
  private void handleSaveType(List<ClientFile> selectionList) {
    final ClientFileChooserSelectionMode selectionMode =
      chooser.getSelectionMode();

    if (selectionList.size() == 0) {
      clearSelection();
      return;
    }

    final ClientFile selection = selectionList.get(0);

    boolean flag = false;

    switch (selectionMode) {
      case DIRECTORIES_ONLY:
        flag = selection.isDirectory();
        break;

      case FILES_ONLY:
        flag = !selection.isDirectory();
        break;
    }

    if (flag) {
      final List<ClientFile> uniq = new ArrayList<ClientFile>();
      uniq.add(selection);
      chooser.setChosenItens(uniq);
    }
    else {
      clearSelection();
    }
  }

  /**
   * Limpeza de seleo.
   */
  private void clearSelection() {
    final List<ClientFile> empty = new ArrayList<ClientFile>();
    chooser.setChosenItens(empty);
  }

  /**
   * Tratador de modo OPEN.
   * 
   * @param selectionList a lista
   */
  private void handleOpenType(List<ClientFile> selectionList) {
    List<ClientFile> realList = new ArrayList<ClientFile>();
    final ClientFileChooserSelectionMode selectionMode =
      chooser.getSelectionMode();
    for (ClientFile s : selectionList) {
      final boolean isDir = s.isDirectory();
      if (isDir && selectionMode == ClientFileChooserSelectionMode.FILES_ONLY) {
        continue;
      }
      if (!isDir
        && selectionMode == ClientFileChooserSelectionMode.DIRECTORIES_ONLY) {
        continue;
      }
      realList.add(s);
    }
    chooser.setChosenItens(realList);
  }

  /**
   * Construtor
   * 
   * @param chooser dilogo.
   */
  ClientFileChooserSelectionListener(ClientFileChooser chooser) {
    this.chooser = chooser;
  }
}
