package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Ao de mostrar o painel com os valores atuais do parmetros de um n do
 * grafo.
 */
public final class ShowParameterValuesAction extends FlowApplicationAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao.
   */
  public ShowParameterValuesAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_VIEWPARAMS_16);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    getApplication().showParameterValues();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    updateEnabled(graph);
  }

  /**
   * Habilita a ao, caso exista pelo menos um n selecionado no grafo.
   * Desabilita, caso contrrio.
   * 
   * @param graph O grafo.
   */
  private void updateEnabled(Graph graph) {
    for (GraphNode node : graph.getNodeCollection()) {
      if (node.isSelected()) {
        setEnabled(true);
        return;
      }
    }
    setEnabled(false);
  }
}
