/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.notepad;

import csbase.client.Client;
import csbase.client.ClientSmartFile;
import csbase.client.ClientSmartFileFactory;
import csbase.client.applications.ApplicationAboutAction;
import csbase.client.applications.ApplicationExitAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.ApplicationProject;
import csbase.client.applications.notepad.SearchPanel;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.Task;
import csbase.client.project.ClientFileLock;
import csbase.client.project.ExportStringTask;
import csbase.client.util.ClientUtilities;
import csbase.client.util.SingletonFileChooser;
import csbase.client.util.charset.CharsetRadioMenu;
import csbase.client.util.charset.CharsetRadioMenuChangeListener;
import csbase.client.util.iostring.TextDealerStatusInterface;
import csbase.client.util.iostring.TextReader;
import csbase.client.util.iostring.TextWriter;
import csbase.exception.project.FileLockedException;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class Notepad
extends ApplicationProject {
    private static final int WAIT_LOCK = 5000;
    private JTextArea textArea = null;
    private boolean needSave = false;
    private boolean readOnlyFile = false;
    private ClientSmartFile currentFile = null;
    private final ReloadController reloadController;
    private static final int PERIOD = 20;
    private static final int SUCCESS_MSG_TIMEOUT = 5;
    private JPanel textAreaPanel;
    private JScrollPane textScrollPane;
    private SearchPanel searchPanel;
    private JButton saveButton;
    private JMenuItem saveItem;
    private final CharsetRadioMenu charsetMenu = new CharsetRadioMenu();
    private float fontSizePercent = 100.0f;
    private static final int ORIGINAL_FONT_SIZE = 12;
    private static final Font FIXED_SIZE_FONT = new Font("Monospaced", 0, 12);
    private static final Font NORMAL_FONT = new Font("Verdana", 0, 12);
    private ClientFileLock clientFileLock;
    private final AbstractAction searchAction = new AbstractAction(this.getString("menu.edit.find")){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Notepad.this.searchPanel.isVisible()) {
                Notepad.this.searchPanel.setVisible(true);
            } else {
                Notepad.this.searchPanel.editSearchString();
            }
        }
    };
    private final AbstractAction searchAgainAction = new AbstractAction(this.getString("menu.edit.findAgain")){

        @Override
        public void actionPerformed(ActionEvent e) {
            Notepad.this.searchPanel.searchAgain();
        }
    };
    private Charset currentCharset;

    private void acquireExclusiveLock(ClientSmartFile file) {
        if (file.equals(this.currentFile)) {
            if (null != this.clientFileLock && this.clientFileLock.getLockStatus() == ClientFileLock.LockStatus.LOCK_EXCLUSIVE) {
                return;
            }
            this.removeLock();
        } else {
            this.removeLock();
        }
        this.clientFileLock = ClientFileLock.acquireExclusiveLock(this.getApplicationFrame(), file.getClientProjectFile(), 5000L);
    }

    private void actionNew() {
        if (this.canCloseFile()) {
            this.resetFile();
        }
    }

    private void actionOpen() {
        try {
            String[] fileTypesArray = this.getAssociatedFileTypes();
            ClientProjectFile cpf = this.browseFileOpen(fileTypesArray, fileTypesArray[0]);
            if (cpf == null) {
                return;
            }
            ClientSmartFile newFile = ClientSmartFileFactory.getInstance().create(cpf);
            String newFileType = newFile.getType();
            boolean logFile = this.looksLikeLogFile(newFileType);
            this.openFile(newFile, logFile);
            if (logFile) {
                this.reloadController.startReloadSchedule();
                this.reloadController.toggleButton.setSelected(true);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void actionReload() {
        if (this.currentFile != null) {
            int caretPosition = this.textArea.getCaretPosition();
            this.loadFile(this.currentFile);
            int textLength = this.textArea.getText().length();
            if (textLength > 0 && caretPosition > 0) {
                if (caretPosition < textLength) {
                    this.textArea.setCaretPosition(caretPosition);
                } else {
                    this.textArea.setCaretPosition(textLength - 1);
                }
            }
        }
    }

    private boolean actionSave() {
        try {
            if (this.currentFile == null) {
                String[] fileTypesArray = this.getAssociatedFileTypes();
                ClientProjectFile cpf = this.browseFileSave(fileTypesArray[0]);
                if (cpf != null) {
                    ClientSmartFile chosenFile = ClientSmartFileFactory.getInstance().create(cpf);
                    this.saveFileAs(chosenFile);
                    return true;
                }
                return false;
            }
            this.saveFileAs(this.currentFile);
            return true;
        }
        catch (Exception e) {
            this.handleError(e);
            return false;
        }
    }

    private String[] getAssociatedFileTypes() {
        List<String> fileTypes = this.getFileTypes();
        if (fileTypes.size() == 0) {
            String err = "no file types linked to notepad!";
            throw new RuntimeException("no file types linked to notepad!");
        }
        String[] preArray = new String[fileTypes.size()];
        String[] fileTypesArray = fileTypes.toArray(preArray);
        return fileTypesArray;
    }

    private void actionSaveAs() {
        try {
            String[] fileTypesArray = this.getAssociatedFileTypes();
            ClientProjectFile cpf = this.browseFileSave(fileTypesArray[0]);
            if (cpf == null) {
                return;
            }
            ClientSmartFile newFile = ClientSmartFileFactory.getInstance().create(cpf);
            this.saveFileAs(newFile);
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private JMenu buildEditMenu() {
        JMenu menu = new JMenu(this.getString("menu.edit"));
        JMenuItem item = new JMenuItem(this.searchAction);
        item.setIcon(ApplicationImages.ICON_FIND_16);
        item.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        menu.add(item);
        item = new JMenuItem(this.searchAgainAction);
        item.setIcon(ApplicationImages.ICON_FIND_16);
        item.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        menu.add(item);
        return menu;
    }

    private JMenu buildFileMenu() {
        JMenu fileMenu = new JMenu(this.getString("menu.file"));
        JMenuItem openItem = fileMenu.add(this.getString("menu.file.open"));
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionOpen();
            }
        });
        openItem.setIcon(ApplicationImages.ICON_OPEN_16);
        fileMenu.add(this.reloadController.menuItem);
        JMenuItem closeItem = fileMenu.add(this.getString("menu.file.close"));
        closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionNew();
            }
        });
        closeItem.setIcon(ApplicationImages.ICON_CLOSE_16);
        this.saveItem = fileMenu.add(this.getString("menu.file.save"));
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionSave();
            }
        });
        this.saveItem.setIcon(ApplicationImages.ICON_SAVE_16);
        JMenuItem saveAsItem = fileMenu.add(this.getString("menu.file.save.as"));
        saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionSaveAs();
            }
        });
        saveAsItem.setIcon(ApplicationImages.ICON_SAVEAS_16);
        fileMenu.addSeparator();
        JMenuItem exportItem = fileMenu.add(this.getString("menu.file.export"));
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.export();
            }
        });
        exportItem.setIcon(ApplicationImages.ICON_BLANK_16);
        fileMenu.addSeparator();
        fileMenu.add(new ApplicationExitAction(this));
        return fileMenu;
    }

    private JMenu buildFontMenu() {
        JMenu menu = new JMenu(this.getString("menu.config.font"));
        JRadioButtonMenuItem fixed = new JRadioButtonMenuItem(new AbstractAction(this.getString("menu.config.font.fixed")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.modifyFontType(true);
            }
        });
        menu.add(fixed);
        JRadioButtonMenuItem normal = new JRadioButtonMenuItem(new AbstractAction(this.getString("menu.config.font.normal")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.modifyFontType(false);
            }
        });
        menu.add(normal);
        ButtonGroup g = new ButtonGroup();
        g.add(fixed);
        g.add(normal);
        fixed.setSelected(true);
        return menu;
    }

    private void buildFrame() {
        ApplicationFrame mainFrame = this.getApplicationFrame();
        mainFrame.setJMenuBar(this.buildMenuBar());
        ((JFrame)mainFrame).getContentPane().add(this.buildPanel());
        mainFrame.setSize(new Dimension(800, 600));
        this.getApplicationFrame().getStatusBar().showStatusBar();
    }

    private JMenu buildHelpMenu() {
        JMenu helpMenu = new JMenu(this.getString("menu.help"));
        helpMenu.add(new ApplicationAboutAction(this));
        return helpMenu;
    }

    private JMenu buildConfigMenu() {
        this.charsetMenu.addCharsetChangeListener(new CharsetRadioMenuChangeListener(){

            @Override
            public void charsetChanged(Charset charset) {
                Notepad.this.currentCharset = charset;
                Notepad.this.actionReload();
            }
        });
        JMenu menu = new JMenu(this.getString("menu.config"));
        menu.add(this.buildFontMenu());
        this.charsetMenu.setText(this.getString("menu.config.charset"));
        menu.add(this.charsetMenu);
        return menu;
    }

    private JMenuBar buildMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.buildFileMenu());
        menuBar.add(this.buildEditMenu());
        menuBar.add(this.buildConfigMenu());
        menuBar.add(this.buildHelpMenu());
        return menuBar;
    }

    private JPanel buildPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildToolBar(), "North");
        panel.add((Component)this.buildTextArea(), "Center");
        return panel;
    }

    private JPanel buildTextArea() {
        this.textAreaPanel = new JPanel(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setFont(FIXED_SIZE_FONT);
        this.textArea.setTabSize(4);
        ClientUtilities.applyUndoRedoActions(this.textArea);
        this.textArea.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiersEx() & 0x80) != 0) {
                    if (e.getScrollType() == 0) {
                        int totalScrollAmount = e.getUnitsToScroll();
                        Notepad.this.modifyFontSize(totalScrollAmount);
                    }
                } else {
                    Notepad.this.textScrollPane.getMouseWheelListeners()[0].mouseWheelMoved(e);
                }
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                Notepad.this.needSave = true;
                Notepad.this.indicateModification();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                Notepad.this.needSave = true;
                Notepad.this.indicateModification();
            }
        });
        this.textScrollPane = new JScrollPane(this.textArea);
        this.textScrollPane.setVerticalScrollBarPolicy(22);
        Dimension scrDim = new Dimension(600, 400);
        this.textScrollPane.setSize(scrDim);
        this.textScrollPane.setPreferredSize(scrDim);
        this.textScrollPane.setMinimumSize(scrDim);
        this.searchPanel = new SearchPanel(this, this.textArea);
        this.textAreaPanel.add((Component)this.searchPanel, new GBC().horizontal());
        this.textAreaPanel.add((Component)this.textScrollPane, new GBC(0, 1).both());
        this.searchPanel.setVisible(false);
        return this.textAreaPanel;
    }

    private JToolBar buildToolBar() {
        String appName = this.getName();
        JToolBar toolBar = new JToolBar(appName);
        toolBar.setFloatable(false);
        JButton openButton = new JButton(ApplicationImages.ICON_OPEN_16);
        openButton.setToolTipText(this.getString("menu.file.open"));
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionOpen();
            }
        });
        this.saveButton = new JButton(ApplicationImages.ICON_SAVE_16);
        this.saveButton.setToolTipText(this.getString("menu.file.save"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionSave();
            }
        });
        JButton saveAsButton = new JButton(ApplicationImages.ICON_SAVEAS_16);
        saveAsButton.setToolTipText(this.getString("menu.file.save.as"));
        saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionSaveAs();
            }
        });
        JButton closeButton = new JButton(ApplicationImages.ICON_CLOSE_16);
        closeButton.setToolTipText(this.getString("menu.file.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notepad.this.actionNew();
            }
        });
        JButton cutButton = new JButton(ApplicationImages.ICON_CUT_16);
        cutButton.setToolTipText(this.getString("menu.edit.cut"));
        cutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JButton copyButton = new JButton(ApplicationImages.ICON_COPY_16);
        copyButton.setToolTipText(this.getString("menu.edit.copy"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JButton pasteButton = new JButton(ApplicationImages.ICON_PASTE_16);
        pasteButton.setToolTipText(this.getString("menu.edit.paste"));
        pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JButton pfsButton = new JButton(ApplicationImages.ICON_PREFERENCES_16);
        pfsButton.setToolTipText(this.getString("menu.edit.prefs"));
        pfsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        JButton aboutButton = new JButton(new ApplicationAboutAction(this));
        aboutButton.setText(null);
        toolBar.add(openButton);
        toolBar.add(this.reloadController.toggleButton);
        toolBar.add(closeButton);
        toolBar.add(this.saveButton);
        toolBar.add(saveAsButton);
        toolBar.addSeparator();
        JButton button = new JButton(ApplicationImages.ICON_FIND_16);
        button.addActionListener(this.searchAction);
        button.setToolTipText(this.getString("menu.edit.find"));
        toolBar.add(button);
        toolBar.addSeparator();
        toolBar.add(aboutButton);
        return toolBar;
    }

    private boolean canCloseFile() {
        boolean result = true;
        if (this.needSave) {
            String noName = this.getString("label.no.name");
            String fileName = this.currentFile != null ? this.currentFile.getName() : noName;
            String fmt = this.getString("msg.close.without.save");
            MessageFormat formatter = new MessageFormat(fmt);
            Object[] arg = new Object[]{fileName};
            String confirmMessage = formatter.format(arg);
            ApplicationFrame mainFrame = this.getApplicationFrame();
            String appName = this.getName();
            int answer = StandardDialogs.showYesNoCancelDialog((Component)mainFrame, (String)appName, (Object)confirmMessage);
            switch (answer) {
                case 0: {
                    result = this.actionSave();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                    break;
                }
                case -1: {
                    result = false;
                }
            }
        }
        if (result) {
            this.removeLock();
        }
        return result;
    }

    private void configHotKeys() {
        JRootPane jRootPane = this.getApplicationFrame().getRootPane();
        InputMap inputMap = jRootPane.getInputMap(1);
        ActionMap aMap = jRootPane.getActionMap();
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, 128);
        inputMap.put(ctrlS, ctrlS.toString());
        aMap.put(ctrlS.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Notepad.this.needSave) {
                    Notepad.this.actionSave();
                }
            }
        });
        KeyStroke ctrlF = KeyStroke.getKeyStroke(70, 128);
        inputMap.put(ctrlF, ctrlF.toString());
        aMap.put(ctrlF.toString(), this.searchAction);
        KeyStroke f3 = KeyStroke.getKeyStroke(114, 0);
        inputMap.put(f3, f3.toString());
        aMap.put(f3.toString(), this.searchAgainAction);
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        inputMap.put(esc, esc.toString());
        aMap.put(esc.toString(), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Notepad.this.searchPanel.isVisible()) {
                    Notepad.this.searchPanel.setVisible(false);
                }
            }
        });
    }

    protected void export() {
        SingletonFileChooser chooser = SingletonFileChooser.getInstance();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        ApplicationFrame window = this.getApplicationFrame();
        int result = chooser.showSaveDialog(window);
        if (result != 0) {
            return;
        }
        File destination = chooser.getSelectedFile();
        String content = this.textArea.getText();
        ExportStringTask task = new ExportStringTask(destination, content, window);
        task.execute(window, this.getString("exportAction.title"), this.getString("exportAction.msg"));
    }

    @Override
    protected final boolean handleError(Exception exception) {
        String msg;
        String appName = this.getName();
        ApplicationFrame mainFrame = this.getApplicationFrame();
        if (StandardDialogs.showYesNoDialog((Component)mainFrame, (String)appName, (Object)(msg = this.getString("internal_error.stack.details"))) == 0) {
            this.showException(this.getName(), exception);
        }
        return true;
    }

    private void indicateModification() {
        if (this.currentFile == null) {
            this.setTitle(null);
        } else {
            this.setTitle(this.currentFile.getName());
        }
    }

    @Override
    public final void killApplication() {
        try {
            this.reloadController.cancelReloadSchedule();
            this.getApplicationFrame().getStatusBar().shutdownTimer();
            if (this.currentFile != null) {
                this.currentFile.close(true);
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void loadFile(ClientSmartFile file) {
        ApplicationFrame frame = this.getApplicationFrame();
        try {
            String content = TextReader.readAllWithTask(frame, file, this.currentCharset);
            if (content == null) {
                this.resetFile();
                return;
            }
            this.currentFile = file;
            this.textArea.setText(content);
            this.needSave = false;
            this.setTitle(this.currentFile.getName());
            this.textArea.setCaretPosition(0);
        }
        catch (OutOfMemoryError o) {
            this.showError(String.format(this.getString("msg.error.no.memory"), file.getName()));
            this.resetFile();
        }
        catch (Exception e) {
            this.resetFile();
        }
    }

    protected void modifyFontSize(int addSize) {
        this.fontSizePercent = this.fontSizePercent + (float)addSize > 200.0f ? 200.0f : (this.fontSizePercent + (float)addSize < 75.0f ? 75.0f : (this.fontSizePercent += (float)addSize));
        Font font = this.textArea.getFont();
        float newFontSize = 12.0f * (this.fontSizePercent / 100.0f);
        this.textArea.setFont(font.deriveFont(newFontSize));
    }

    protected void modifyFontType(boolean fixed) {
        float fontSize = 12.0f * (this.fontSizePercent / 100.0f);
        if (fixed) {
            this.textArea.setFont(FIXED_SIZE_FONT.deriveFont(fontSize));
        } else {
            this.textArea.setFont(NORMAL_FONT.deriveFont(fontSize));
        }
    }

    private void openFile(ClientSmartFile file, boolean readOnly) {
        if (file == null) {
            this.showError(this.getString("msg.error.open.null"));
            return;
        }
        if (file.isDirectory()) {
            this.showError(this.getString("msg.error.open.directory"));
            return;
        }
        this.readOnlyFile = readOnly;
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        if (!project.userHasAccessRW(User.getLoggedUser().getId())) {
            this.readOnlyFile = true;
        }
        if (!this.readOnlyFile) {
            this.acquireExclusiveLock(file);
            if (this.clientFileLock == null || this.clientFileLock.getLockStatus() != ClientFileLock.LockStatus.LOCK_EXCLUSIVE) {
                int option = StandardDialogs.showYesNoDialog((Component)this.getApplicationFrame(), (String)this.getName(), (Object)String.format(this.getString("Notepad.open.readonly.msg"), file.getName()));
                if (option == 0) {
                    this.removeLock();
                    this.openFile(file, true);
                } else {
                    this.resetFile();
                }
                return;
            }
        }
        this.setReadOnlyMode(this.readOnlyFile);
        this.loadFile(file);
    }

    private void removeLock() {
        if (this.clientFileLock == null) {
            return;
        }
        this.clientFileLock.releaseLock(this.getApplicationFrame());
        this.clientFileLock = null;
    }

    private void resetFile() {
        this.reloadController.cancelReloadSchedule();
        this.textArea.setText("");
        this.setReadOnlyMode(false);
        this.readOnlyFile = false;
        this.currentFile = null;
        this.needSave = false;
        this.setTitle(null);
        this.clientFileLock = null;
    }

    private void saveFileAs(final ClientSmartFile file) {
        ClientFileLock.LockStatus lockStatus;
        if (file == null) {
            this.showError(this.getString("msg.error.save.null"));
            return;
        }
        if (file.isDirectory()) {
            this.showError(this.getString("msg.error.save.directory"));
            return;
        }
        this.acquireExclusiveLock(file);
        ClientFileLock.LockStatus lockStatus2 = lockStatus = this.clientFileLock == null ? null : this.clientFileLock.getLockStatus();
        if (lockStatus != ClientFileLock.LockStatus.LOCK_EXCLUSIVE) {
            this.showInformation(String.format(this.getString("Notepad.no.lock.msg"), file.getName()));
            return;
        }
        final String content = this.textArea.getText();
        final ApplicationFrame frame = this.getApplicationFrame();
        Task<Void> task = new Task<Void>(){

            @Override
            protected void handleError(Exception error) {
                if (error instanceof FileLockedException) {
                    StandardDialogs.showErrorDialog((Component)frame, (String)Notepad.this.getName(), (String)String.format(Notepad.this.getString("Notepad.file.locked.error"), file.getName()));
                } else {
                    super.handleError(error);
                }
            }

            public void performTask() throws Exception {
                TextDealerStatusInterface statusDealer = new TextDealerStatusInterface(){

                    @Override
                    public void setTextOperationPercentage(int perc) {
                        this.setProgressStatus(perc);
                    }

                    @Override
                    public boolean isTextOperationInterrupted() {
                        return this.wasCancelled();
                    }
                };
                this.setProgressStatus(10);
                TextWriter.writeAllWithoutTask(file, content, Notepad.this.currentCharset, statusDealer);
                Notepad.this.currentFile = file;
                String date = Utilities.getFormattedDate((long)new Date().getTime());
                String userName = User.getLoggedUser().getName();
                String userLogin = User.getLoggedUser().getLogin();
                MessageFormat formatter = new MessageFormat(Notepad.this.getString("msg.saved.description"));
                String appName = Notepad.this.getName();
                Object[] arg = new Object[]{date, appName, userLogin, userName};
                String message = formatter.format(arg);
                file.getClientProjectFile().appendDescription(message + "\n");
            }
        };
        String saveMsg = this.getString("msg.saving.file");
        if (task.execute(frame, this.getName(), saveMsg, true, false)) {
            this.needSave = false;
            this.setTitle(file.getName());
            this.getApplicationFrame().getStatusBar().setInfo(this.getString("msg.success.save"), 5);
        }
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (value == null) {
            return;
        }
        if (name.equals("PROJECT_FILE")) {
            ClientProjectFile cpf = (ClientProjectFile)value;
            ClientSmartFile file = ClientSmartFileFactory.getInstance().create(cpf);
            String fileType = file.getType();
            boolean logFile = this.looksLikeLogFile(fileType);
            this.openFile(file, logFile);
            if (logFile) {
                this.reloadController.startReloadSchedule();
                this.reloadController.toggleButton.setSelected(true);
            }
        }
    }

    private boolean looksLikeLogFile(String fileType) {
        if (fileType == null) {
            return false;
        }
        boolean logFile = fileType.equals("LOG");
        return logFile;
    }

    private void setReadOnlyMode(boolean activate) {
        if (this.readOnlyFile || activate) {
            this.textArea.setEditable(false);
            this.saveButton.setEnabled(false);
            this.saveItem.setEnabled(false);
            this.textArea.setBackground(Color.lightGray);
        } else {
            this.textArea.setEditable(true);
            this.saveButton.setEnabled(true);
            this.saveItem.setEnabled(true);
            this.textArea.setBackground(Color.white);
        }
    }

    private void setTitle(String title) {
        String filename = title;
        this.getApplicationFrame().getStatusBar().clearStatus();
        filename = filename == null ? this.getName() : this.getName() + " - " + filename;
        if (this.needSave) {
            filename = filename + "*";
        } else if (!this.textArea.isEditable()) {
            filename = filename + " [" + this.getString("title.read.only") + "]";
        }
        this.getApplicationFrame().setTitle(filename);
    }

    @Override
    public final boolean userCanKillApplication() {
        return this.canCloseFile();
    }

    public Notepad(String id) {
        super(id);
        Client client = Client.getInstance();
        this.currentCharset = client.getSystemDefaultCharset();
        this.reloadController = new ReloadController();
        this.buildFrame();
        this.configHotKeys();
    }

    class ReloaderTask
    extends TimerTask {
        ReloaderTask() {
        }

        @Override
        public void run() {
            if (((Notepad)Notepad.this).reloadController.timer != null && ((Notepad)Notepad.this).reloadController.isReloading) {
                try {
                    SwingThreadDispatcher.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Notepad.this.actionReload();
                        }
                    });
                }
                catch (InterruptedException e) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
                if (Notepad.this.reloadController.isReloading()) {
                    Notepad.this.reloadController.scheduleAnotherReload();
                }
            }
        }
    }

    private class ReloadController {
        public Timer timer = new Timer();
        public boolean isReloading;
        public JMenuItem menuItem;
        public JToggleButton toggleButton;
        private boolean isBeingSync = false;

        public void cancelReloadSchedule() {
            if (this.isReloading) {
                this.timer.cancel();
                this.timer = new Timer();
            }
            this.setReloading(false);
        }

        private void changeState() {
            if (this.isReloading()) {
                this.cancelReloadSchedule();
                if (Notepad.this.currentFile != null) {
                    Notepad.this.loadFile(Notepad.this.currentFile);
                }
                Notepad.this.setReadOnlyMode(false);
            } else {
                Notepad.this.setReadOnlyMode(true);
                this.startReloadSchedule();
            }
        }

        public boolean isReloading() {
            return this.isReloading;
        }

        private void scheduleAnotherReload() {
            this.timer.schedule((TimerTask)new ReloaderTask(), 20000L);
        }

        private void setReloading(boolean willBeReloading) {
            this.isBeingSync = true;
            this.isReloading = willBeReloading;
            this.toggleButton.setSelected(willBeReloading);
            if (willBeReloading) {
                String text = Notepad.this.getString("menu.file.reload.stop");
                this.toggleButton.setToolTipText(text);
                this.menuItem.setText(text);
            } else {
                String text = Notepad.this.getString("menu.file.reload.start");
                this.toggleButton.setToolTipText(text);
                this.menuItem.setText(text);
            }
            this.isBeingSync = false;
            Notepad.this.setReadOnlyMode(willBeReloading);
        }

        public void startReloadSchedule() {
            String fmt;
            String appName;
            ApplicationFrame mainFrame;
            int answer;
            if (Notepad.this.needSave && (answer = StandardDialogs.showYesNoDialog((Component)(mainFrame = Notepad.this.getApplicationFrame()), (String)(appName = Notepad.this.getName()), (Object)(fmt = Notepad.this.getString("msg.warn.start.reload")))) != 0) {
                this.cancelReloadSchedule();
                return;
            }
            this.cancelReloadSchedule();
            this.setReloading(true);
            Notepad.this.actionReload();
            this.scheduleAnotherReload();
        }

        public ReloadController() {
            String text = Notepad.this.getString("menu.file.reload.start");
            this.menuItem = new JMenuItem(text);
            this.menuItem.setIcon(ApplicationImages.ICON_REFRESH_16);
            this.toggleButton = new JToggleButton(ApplicationImages.ICON_REFRESH_16);
            this.toggleButton.setToolTipText(text);
            this.isReloading = false;
            this.toggleButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!ReloadController.this.isBeingSync) {
                        ReloadController.this.changeState();
                    }
                }
            });
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ReloadController.this.isBeingSync) {
                        ReloadController.this.changeState();
                    }
                }
            });
        }
    }
}

