/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.columns;

import csbase.client.applications.ApplicationImages;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class NodeAllocationColumn
extends AbstractConfigurableColumn<SGAInfo> {
    public NodeAllocationColumn(String id, Boolean visible, IStringProvider stringProvider, Integer align) {
        super(id, visible, stringProvider, align);
    }

    public Class<?> getColumnClass() {
        return Allocation.class;
    }

    public String getColumnName() {
        return this.getString(this.getId());
    }

    public Object getValue(SGAInfo obj) {
        return Allocation.getAllocation(obj);
    }

    @Override
    public Comparator<Allocation> getComparator() {
        return new Comparator<Allocation>(){

            @Override
            public int compare(Allocation first, Allocation second) {
                return first.compareTo(second);
            }
        };
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Allocation alloc = (Allocation)((Object)value);
                this.setText(null);
                this.setIcon(alloc.getImage());
                this.setToolTipText(NodeAllocationColumn.this.getString("tooltip." + alloc.toString().toLowerCase()));
                return this;
            }
        };
    }

    private static enum Allocation {
        FREE(ApplicationImages.GREEN_BALL_16),
        PARTIALLY_BUSY(ApplicationImages.YELLOW_BALL_16),
        BUSY(ApplicationImages.RED_BALL_16),
        OFF(ApplicationImages.GRAY_BALL_16);

        private ImageIcon image;

        private Allocation(ImageIcon image) {
            this.image = image;
        }

        public ImageIcon getImage() {
            return this.image;
        }

        public static Allocation getAllocation(SGAInfo node) {
            if (node.getAlive()) {
                Allocation alloc = PARTIALLY_BUSY;
                if (node.getNumberOfJobs() == 0) {
                    alloc = FREE;
                } else if (node.getNumberOfJobs() == node.getNumProcessors()) {
                    alloc = BUSY;
                }
                return alloc;
            }
            return OFF;
        }
    }
}

