package csbase.client.applications.algorithmsmanager.report.core;

/**
 * Implementao padro da mensagem
 * 
 *
 * @author Tecgraf/PUC-Rio
 * @param <T> Tipo do objeto sendo analisado
 */
public class ResultMessage<T> implements IResultMessage<T> {

  /** O objeto sendo analisado */
  private final T subject;

  /** O status do teste */
  private final TestStatus status;

  /** A mensagem */
  private final String message;

  /**
   * Construtor pado
   * 
   * @param subject O objeto sendo analisado.
   * @param status O status do teste.
   * @param message A mensagem.
   */
  public ResultMessage(T subject, TestStatus status, String message) {
    super();
    this.subject = subject;
    this.status = status;
    this.message = message;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public T getSubject() {
    return subject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TestStatus getStatus() {
    return status;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getMessage() {
    return message;
  }
}
