/*
 * $Id: CloseLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;

/**
 * Fecha o arquivo csv corrente.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class CloseCSVAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public CloseCSVAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_CLOSE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    CSVViewer application = getApplication();
    application.closeFile();
  }
}
